package net.danygames2014.uniwrench.mixin;

import net.danygames2014.uniwrench.item.WrenchBase;
import net.minecraft.class_31;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.class_76;
import net.minecraft.class_92;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_92.class)
public class ItemRendererMixin {
    @Unique
    private void fillRect(class_67 tessellator, int x, int y, int width, int height, int color, int alpha) {
        tessellator.method_1695();
        tessellator.method_1692(color, alpha);
        tessellator.method_1687(x, y, 0.0F);
        tessellator.method_1687(x, (y + height), 0.0F);
        tessellator.method_1687((x + width), (y + height), 0.0F);
        tessellator.method_1687((x + width), y, 0.0F);
        tessellator.method_1685();
    }

    @Inject(method = "renderGuiItemDecoration", at = @At("HEAD"))
    void render(class_34 textRenderer, class_76 textureManager, class_31 stack, int x, int y, CallbackInfo ci){
        if(stack != null && stack.method_694() instanceof WrenchBase wrenchBase && wrenchBase.usageDelay > 0){
            int delay = wrenchBase.getDelay(stack);
            if(delay == 0) return;
            int offset = (int) (16 * (1.0 - (double) delay / wrenchBase.usageDelay));

            GL11.glDisable(GL11.GL_LIGHTING);
            GL11.glDisable(GL11.GL_DEPTH_TEST);
            GL11.glDisable(GL11.GL_TEXTURE_2D);
            GL11.glEnable(GL11.GL_BLEND);
            GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

            fillRect(class_67.field_2054, x, y + offset, 16, 16 - offset, 0xFFFFFF, 90);

            GL11.glEnable(GL11.GL_LIGHTING);
            GL11.glEnable(GL11.GL_DEPTH_TEST);
            GL11.glEnable(GL11.GL_TEXTURE_2D);
            GL11.glDisable(GL11.GL_BLEND);

        }
    }
}
