package net.danygames2014.whatsthis;

import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.apache.commons.lang3.text.WordUtils;

import static net.danygames2014.whatsthis.api.IProbeConfig.ConfigMode.EXTENDED;
import static net.danygames2014.whatsthis.api.IProbeConfig.ConfigMode.NORMAL;

public class Util {
    public static class_57 getEntity(class_18 world, int entityId) {
        for (var entity : world.field_198) {
            if (((class_57) entity).field_1591 == entityId) {
                return (class_57) entity;
            }
        }
        return null;
    }

    private static String modName = "";
    public static String getModName(class_17 block) {
        Identifier identifier = BlockRegistry.INSTANCE.getId(block);

        if (identifier == null) {
            modName = "Minecraft";
        } else {
            modName = identifier.namespace.toString();
        }

        return formatModName(modName);
    }

    public static String getModName(class_57 entity) {
        String[] enttityName = class_206.method_734(entity).split(":");

        if (enttityName.length <= 1) {
            modName = "Minecraft";
        } else {
            modName = enttityName[1];
        }

        return formatModName(modName);
    }

    @SuppressWarnings("deprecation")
    public static String formatModName(String input) {
        return WordUtils.capitalizeFully(input);
    }

    public static boolean show(ProbeMode mode, IProbeConfig.ConfigMode cfg) {
        return cfg == NORMAL || (cfg == EXTENDED && mode == ProbeMode.EXTENDED) || mode == ProbeMode.DEBUG;
    }
}
