package net.danygames2014.whatsthis.api;

import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.block.BlockState;

/**
 * Implement this interface if you want to override the default
 * probe config for some of your blocks or entities.
 */
public interface IProbeConfigProvider {

    /**
     * Possibly override the config for this entity. You can make modifications to the given 'config' which starts
     * from default.
     */
    void getProbeConfig(IProbeConfig config, class_54 player, class_18 world, class_57 entity, IProbeHitEntityData data);

    /**
     * Possibly override the config for this block. You can make modifications to the given 'config' which starts
     * from default.
     */
    void getProbeConfig(IProbeConfig config, class_54 player, class_18 world, BlockState blockState, IProbeHitData data);

}
