package net.danygames2014.whatsthis.apiimpl.providers.entity;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IProbeHitEntityData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProbeInfoEntityProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.apiimpl.styles.LayoutStyle;
import net.danygames2014.whatsthis.config.Config;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_54;
import net.minecraft.class_57;

import static net.danygames2014.whatsthis.api.TextStyleClass.INFO;
import static net.danygames2014.whatsthis.api.TextStyleClass.LABEL;


public class DebugProbeInfoEntityProvider implements IProbeInfoEntityProvider {

    @Override
    public String getID() {
        return WhatsThis.NAMESPACE.id("entity_debug").toString();
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, class_57 entity, IProbeHitEntityData data) {
        if (mode == ProbeMode.DEBUG && Config.PROBE_CONFIG.showDebugInfo) {
            IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(0xffff4444).spacing(2));

            // Entity ID Info
            String registryId = class_206.method_734(entity);
            int entityId = entity.field_1591;

            vertical
                    .text(LABEL + "Registry ID: " + INFO + registryId)
                    .text(LABEL + "Entity ID: " + INFO + entityId)
            ;

            // Living Entity Info
            if (entity instanceof class_127 livingEntity) {
                int health = livingEntity.field_1036;
                int maxHealth = livingEntity.field_1009;
                float damageAmount = livingEntity.field_1025;

                vertical
                        .text(LABEL + "Health: " + health + " / " + maxHealth)
                        .text(LABEL + "Damage: " + damageAmount)
                ;
            }

            // Other Info
            int age = entity.field_1645;
            float width = entity.field_1632;
            float height = entity.field_1633;
            int fireTicks = entity.field_1647;
            int air = entity.field_1614;
            int maxAir = entity.field_1648;

            vertical
                    .text(LABEL + "Age: " + INFO + age)
                    .text(LABEL + "Width: " + INFO + width)
                    .text(LABEL + "Height: " + INFO + height)
                    .text(LABEL + "FireTicks: " + INFO + fireTicks)
                    .text(LABEL + "Air: " + INFO + air + " / " + maxAir)
            ;
        }
    }
}
