package net.danygames2014.whatsthis.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.*;
import net.danygames2014.whatsthis.apiimpl.ProbeHitEntityData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import org.jetbrains.annotations.NotNull;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

import static net.danygames2014.whatsthis.Util.getEntity;
import static net.danygames2014.whatsthis.api.TextStyleClass.ERROR;
import static net.danygames2014.whatsthis.api.TextStyleClass.LABEL;
import static net.danygames2014.whatsthis.config.ConfigSetup.PROBE_NEEDEDFOREXTENDED;
import static net.danygames2014.whatsthis.config.ConfigSetup.PROBE_NEEDEDHARD;

public class PacketGetEntityInfo extends class_169 implements ManagedPacket<PacketGetEntityInfo> {
    public static final PacketType<PacketGetEntityInfo> TYPE = PacketType.builder(false, true, PacketGetEntityInfo::new).build();

    private int dim;
    private int entityId;
    private ProbeMode mode;
    private class_26 hitVec;

    private int size;

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, class_27 mouseOver, class_57 entity) {
        this.dim = dim;
        this.entityId = entity.field_1591;
        this.mode = mode;
        this.hitVec = class_26.method_1293(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986);
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            dim = stream.readInt();
            entityId = stream.readInt();
            mode = ProbeMode.values()[stream.readByte()];
            if (stream.readBoolean()) {
                hitVec = class_26.method_1293(stream.readDouble(), stream.readDouble(), stream.readDouble());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();

            stream.writeInt(dim); // 4b
            stream.writeInt(entityId); // 4b
            stream.writeByte(mode.ordinal()); // 1b
            if (hitVec == null) {
                stream.writeBoolean(false); // 1b
            } else {
                stream.writeBoolean(true); // 1b
                stream.writeDouble(hitVec.field_1585); // 8b
                stream.writeDouble(hitVec.field_1586); // 8b
                stream.writeDouble(hitVec.field_1587); // 8b
            }

            this.size = stream.size() - initialStreamSize;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_808(class_240 networkHandler) {
        switch (FabricLoader.getInstance().getEnvironmentType()) {
            case CLIENT -> {
                handleClient(networkHandler);
            }
            case SERVER -> {
                handleServer(networkHandler);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void handleClient(class_240 networkHandler) {
        class_18 world = Minecraft.field_2791.field_2804;
        if (world != null) {
            class_57 entity = getEntity(world, entityId);
            if (entity != null) {
                ProbeInfo probeInfo = getProbeInfo(Minecraft.field_2791.field_2806, mode, world, entity, hitVec);
                PacketHelper.sendTo(Minecraft.field_2791.field_2806, new PacketReturnEntityInfo(entityId, probeInfo));
            }
        }
    }

    @Environment(EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11 handler) {
            class_18 world = handler.field_920.field_1596;
            if (world != null) {
                class_57 entity = getEntity(world, entityId);
                if (entity != null) {
                    ProbeInfo probeInfo = getProbeInfo(handler.field_920, mode, world, entity, hitVec);
                    PacketHelper.sendTo(handler.field_920, new PacketReturnEntityInfo(entityId, probeInfo));
                }
            }
        }
    }

    @Override
    public int method_798() {
        return this.size;
    }

    private static ProbeInfo getProbeInfo(class_54 player, ProbeMode mode, class_18 world, class_57 entity, class_26 hitVec) {
        if (Config.PROBE_CONFIG.needsProbe == PROBE_NEEDEDFOREXTENDED) {
            // We need a probe only for extended information
            if (!ProbeUtil.hasAProbeSomewhere(player)) {
                // No probe anywhere, switch EXTENDED to NORMAL
                if (mode == ProbeMode.EXTENDED) {
                    mode = ProbeMode.NORMAL;
                }
            }
        } else if (Config.PROBE_CONFIG.needsProbe == PROBE_NEEDEDHARD && !ProbeUtil.hasAProbeSomewhere(player)) {
            // The server says we need a probe but we don't have one in our hands or on our head
            return null;
        }

        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        IProbeHitEntityData data = new ProbeHitEntityData(hitVec);

        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = WhatsThis.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        ConfigSetup.setProbeConfig(probeConfig);

        List<IProbeInfoEntityProvider> entityProviders = WhatsThis.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            } catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(LABEL + "Error: " + ERROR + provider.getID());
            }
        }
        return probeInfo;
    }

    @Override
    public @NotNull PacketType<PacketGetEntityInfo> getType() {
        return TYPE;
    }
}
