package net.danygames2014.whatsthis.rendering;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.*;
import net.danygames2014.whatsthis.apiimpl.ProbeHitData;
import net.danygames2014.whatsthis.apiimpl.ProbeHitEntityData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.apiimpl.elements.ElementProgress;
import net.danygames2014.whatsthis.apiimpl.elements.ElementText;
import net.danygames2014.whatsthis.apiimpl.providers.block.DefaultProbeInfoProvider;
import net.danygames2014.whatsthis.apiimpl.providers.entity.DefaultProbeInfoEntityProvider;
import net.danygames2014.whatsthis.apiimpl.styles.ProgressStyle;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.network.PacketGetEntityInfo;
import net.danygames2014.whatsthis.network.PacketGetInfo;
import net.danygames2014.whatsthis.network.ThrowableIdentity;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_212;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_520;
import net.minecraft.class_54;
import net.minecraft.class_564;
import net.minecraft.class_57;
import net.minecraft.class_608;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

import static net.danygames2014.whatsthis.api.TextStyleClass.ERROR;

@SuppressWarnings("DuplicatedCode")
public class OverlayRenderer {

    private static Map<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<>();
    private static Map<Integer, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<>();
    private static long lastCleanupTime = 0;

    // For a short while we keep displaying the last pair if we have no new information
    // to prevent flickering
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime = 0;

    // When the server delays too long we also show some preliminary information already
    private static long lastRenderedTime = -1;

    public static void renderHUD(ProbeMode mode, float partialTicks) {
        float dist = Config.PROBE_CONFIG.probeDistance;

        class_27 mouseOver = Minecraft.field_2791.field_2823;
        if (mouseOver != null) {
            if (mouseOver.field_1983 == class_212.field_790) {
                GL11.glPushMatrix();

                double scale = Config.CLIENT_CONFIG.tooltipScale;

                Minecraft minecraft = Minecraft.field_2791;
                class_564 screenScaler = new class_564(minecraft.field_2824, minecraft.field_2802, minecraft.field_2803);
                double sw = screenScaler.method_1857();
                double sh = screenScaler.method_1858();

                RenderHelper.setupOverlayRendering(sw * scale, sh * scale);
                renderHUDEntity(mode, mouseOver, sw * scale, sh * scale);
                RenderHelper.setupOverlayRendering(sw, sh);
                GL11.glPopMatrix();

                checkCleanup();
                return;
            }
        }

        class_54 entity = Minecraft.field_2791.field_2806;
        class_26 start = entity.method_931(partialTicks);
        class_26 vec31 = entity.method_926(partialTicks);
        class_26 end = start.method_1301(vec31.field_1585 * dist, vec31.field_1586 * dist, vec31.field_1587 * dist);

        mouseOver = entity.field_1596.method_161(start, end, Config.CLIENT_CONFIG.showLiquids);
        if (mouseOver == null) {
            return;
        }

        if (mouseOver.field_1983 == class_212.field_789) {
            GL11.glPushMatrix();

            double scale = Config.CLIENT_CONFIG.tooltipScale;

            class_564 scaledresolution = new class_564(Minecraft.field_2791.field_2824, Minecraft.field_2791.field_2802, Minecraft.field_2791.field_2803);
            double sw = scaledresolution.method_1857();
            double sh = scaledresolution.method_1858();

            RenderHelper.setupOverlayRendering(sw * scale, sh * scale);
            renderHUDBlock(mode, mouseOver, sw * scale, sh * scale);
            RenderHelper.setupOverlayRendering(sw, sh);

            GL11.glPopMatrix();
        }

        checkCleanup();
    }

    private static void renderHUDBlock(ProbeMode mode, class_27 mouseOver, double sw, double sh) {
        class_339 blockPos = new class_339(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986);

        class_54 player = Minecraft.field_2791.field_2806;
        if (player.field_1596.method_234(blockPos.field_2100, blockPos.field_2101, blockPos.field_2102)) {
            return;
        }

        long time = System.currentTimeMillis();

        IElement damageElement = null;
        if (Config.CLIENT_CONFIG.showBreakProgress > 0) {
            float damage = 0.0F;

            if (Minecraft.field_2791.field_2801 instanceof class_608 multiplayerInteractionManager) {
                damage = multiplayerInteractionManager.field_2611;
            } else if (Minecraft.field_2791.field_2801 instanceof class_520 singleplayerInteractionManager) {
                damage = singleplayerInteractionManager.field_2184;
            }

            if (damage > 0) {
                if (Config.CLIENT_CONFIG.showBreakProgress == 2) {
                    damageElement = new ElementText(Formatting.RED + "Progress " + (int) (damage * 100) + "%");
                } else {
                    damageElement = new ElementProgress((long) (damage * 100), 100, new ProgressStyle()
                            .prefix("Progress ")
                            .suffix("%")
                            .width(85)
                            .borderColor(0)
                            .filledColor(0)
                            .filledColor(0xff990000)
                            .alternateFilledColor(0xff550000));
                }
            }
        }

        int dimension = player.field_1596.field_216.field_2179;
        Pair<Integer, class_339> key = Pair.of(dimension, blockPos);
        Pair<Long, ProbeInfo> cacheEntry = cachedInfo.get(key);
        if (cacheEntry == null || cacheEntry.getValue() == null) {

            // To make sure we don't ask it too many times before the server got a chance to send the answer
            // we insert a dummy entry here for a while
            if (cacheEntry == null || time >= cacheEntry.getLeft()) {
                cachedInfo.put(key, Pair.of(time + 500, null));
                requestBlockInfo(mode, mouseOver, blockPos, player);
            }

            if (lastPair != null && time < lastPairTime + Config.PROBE_CONFIG.timeout) {
                renderElements(lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            } else if (Config.PROBE_CONFIG.waitingForServerTimeout > 0 && lastRenderedTime != -1 && time > lastRenderedTime + Config.PROBE_CONFIG.waitingForServerTimeout) {
                // It has been a while. Show some info on client that we are
                // waiting for server information
                ProbeInfo info = getWaitingInfo(mode, mouseOver, blockPos, player);
                registerProbeInfo(dimension, blockPos, info);
                lastPair = Pair.of(time, info);
                lastPairTime = time;
                renderElements(lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            }
        } else {
            if (time > cacheEntry.getLeft() + Config.PROBE_CONFIG.timeout) {
                // This info is slightly old. Update it

                // To make sure we don't ask it too many times before the server got a chance to send the answer
                // we increase the time a bit here
                cachedInfo.put(key, Pair.of(time + 500, cacheEntry.getRight()));
                requestBlockInfo(mode, mouseOver, blockPos, player);
            }
            renderElements(cacheEntry.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, damageElement);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static void renderHUDEntity(ProbeMode mode, class_27 mouseOver, double sw, double sh) {
        class_57 entity = mouseOver.field_1989;
        if (entity == null) {
            return;
        }

        String entityString = class_206.method_734(entity);
        if (entityString == null && !(entity instanceof class_54)) {
            // We can't show info for this entity
            return;
        }

        int entityId = entity.field_1591;

        class_54 player = Minecraft.field_2791.field_2806;
        long time = System.currentTimeMillis();

        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(entityId);
        if (cacheEntry == null || cacheEntry.getValue() == null) {

            // To make sure we don't ask it too many times before the server got a chance to send the answer
            // we insert a dummy entry here for a while
            if (cacheEntry == null || time >= cacheEntry.getLeft()) {
                cachedEntityInfo.put(entityId, Pair.of(time + 500, null));
                requestEntityInfo(mode, mouseOver, entity, player);
            }

            if (lastPair != null && time < lastPairTime + Config.PROBE_CONFIG.timeout) {
                renderElements(lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            } else if (Config.PROBE_CONFIG.waitingForServerTimeout > 0 && lastRenderedTime != -1 && time > lastRenderedTime + Config.PROBE_CONFIG.waitingForServerTimeout) {
                // It has been a while. Show some info on client that we are
                // waiting for server information
                ProbeInfo info = getWaitingEntityInfo(mode, mouseOver, entity, player);
                registerProbeInfo(entityId, info);
                lastPair = Pair.of(time, info);
                lastPairTime = time;
                renderElements(lastPair.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            }
        } else {
            if (time > cacheEntry.getLeft() + Config.PROBE_CONFIG.timeout) {
                // This info is slightly old. Update it

                // To make sure we don't ask it too many times before the server got a chance to send the answer
                // we increase the time a bit here
                cachedEntityInfo.put(entityId, Pair.of(time + 500, cacheEntry.getRight()));
                requestEntityInfo(mode, mouseOver, entity, player);
            }
            renderElements(cacheEntry.getRight(), ConfigSetup.getDefaultOverlayStyle(), sw, sh, null);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    public static void renderElements(ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }

        RenderHelper.disableLighting();

        int scaledWidth = (int) sw;
        int scaledHeight = (int) sh;

        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();

        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }

        int x;
        int y;
        if (style.getLeftX() != -1) {
            x = style.getLeftX();
        } else if (style.getRightX() != -1) {
            x = scaledWidth - w - style.getRightX();
        } else {
            x = (scaledWidth - w) / 2;
        }
        if (style.getTopY() != -1) {
            y = style.getTopY();
        } else if (style.getBottomY() != -1) {
            y = scaledHeight - h - style.getBottomY();
        } else {
            y = (scaledHeight - h) / 2;
        }

        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x + w - 1, y + h - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x + w - 1 - offset, y + h - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }

        if (!Minecraft.field_2791.field_2813) {
            RenderHelper.rot += .5f;
        }

        probeInfo.render(x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    // Request Info
    private static void requestBlockInfo(ProbeMode mode, class_27 mouseOver, class_339 pos, class_54 player) {
        class_18 world = player.field_1596;
        BlockState blockState = world.getBlockState(pos);

        class_31 pickBlock = new class_31(blockState.getBlock(), 1, world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102));

//         TODO: handle pickBlock
//        ItemStack pickBlock = block.getPickBlock(blockState, mouseOver, world, blockPos, player);
//        if (pickBlock == null || (!pickBlock.isEmpty() && pickBlock.getItem() == null)) {
//            // Protection for some invalid items.
//            pickBlock = ItemStack.EMPTY;
//        }
//        if (pickBlock != null && (!pickBlock.isEmpty()) && ConfigSetup.getDontSendNBTSet().contains(pickBlock.getItem().getRegistryName())) {
//            pickBlock = pickBlock.copy();
//            pickBlock.setTagCompound(null);
//        }

        PacketHelper.send(new PacketGetInfo(world.field_216.field_2179, pos, mode, mouseOver, pickBlock));
    }
    private static void requestEntityInfo(ProbeMode mode, class_27 mouseOver, class_57 entity, class_54 player) {
        PacketHelper.send(new PacketGetEntityInfo(player.field_1596.field_216.field_2179, mode, mouseOver, entity));
    }

    // Register Info
    public static void registerProbeInfo(int dim, class_339 pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put(Pair.of(dim, pos), Pair.of(time, probeInfo));
    }

    public static void registerProbeInfo(int entityId, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(entityId, Pair.of(time, probeInfo));
    }


    // Waiting Info
    private static ProbeInfo getWaitingInfo(ProbeMode mode, class_27 mouseOver, class_339 pos, class_54 player) {
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();

        class_18 world = player.field_1596;
        BlockState state = world.getBlockState(pos);
        class_17 block = state.getBlock();
        class_31 pickBlock = new class_31(block, 1, world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102));
        IProbeHitData data = new ProbeHitData(pos, class_26.method_1293(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986), Direction.byId(mouseOver.field_1987), pickBlock);

        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();

        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(mode, probeInfo, world, pos, state, block, player, data, probeConfig);
        } catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(ERROR + "Error (see log for details)!");
        }

        probeInfo.text(ERROR + "Waiting for server...");
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, class_27 mouseOver, class_57 entity, class_54 player) {
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        IProbeHitEntityData data = new ProbeHitEntityData(class_26.method_1293(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986));

        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        } catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(ERROR + "Error (see log for details)!");
        }

        probeInfo.text(ERROR + "Waiting for server...");
        return probeInfo;
    }

    // Cleanup
    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000) {
            cleanupCachedBlocks(time);
            cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void cleanupCachedBlocks(long time) {
        // It has been a while. Time to clean up unused cached pairs.
        Map<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<>();
        for (Map.Entry<Pair<Integer, class_339>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = entry.getValue().getLeft();
            if (time < t + Config.PROBE_CONFIG.timeout + 1000) {
                newCachedInfo.put(entry.getKey(), entry.getValue());
            }
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        // It has been a while. Time to clean up unused cached pairs.
        Map<Integer, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<>();
        for (Map.Entry<Integer, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = entry.getValue().getLeft();
            if (time < t + Config.PROBE_CONFIG.timeout + 1000) {
                newCachedInfo.put(entry.getKey(), entry.getValue());
            }
        }
        cachedEntityInfo = newCachedInfo;
    }
}
