/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IEntityStyle;
import net.danygames2014.whatsthis.apiimpl.TheOneProbeImp;
import net.danygames2014.whatsthis.apiimpl.client.ElementEntityRender;
import net.danygames2014.whatsthis.apiimpl.styles.EntityStyle;
import net.danygames2014.whatsthis.network.NetworkUtil;
import net.minecraft.class_206;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;

public class ElementEntity
implements IElement {
    private final String entityName;
    private final Integer playerID;
    private final class_8 entityNbt;
    private final IEntityStyle style;

    public ElementEntity(String entityName, IEntityStyle style) {
        this.entityName = entityName;
        this.entityNbt = new class_8();
        this.style = style;
        this.playerID = null;
    }

    public ElementEntity(class_57 entity, IEntityStyle style) {
        this.entityName = class_206.method_734((class_57)entity);
        if (entity instanceof class_54) {
            class_54 player = (class_54)entity;
            this.entityNbt = new class_8();
            this.playerID = player.field_1591;
        } else {
            this.entityNbt = new class_8();
            entity.method_1346(this.entityNbt);
            this.playerID = null;
        }
        this.style = style;
    }

    public ElementEntity(DataInputStream stream) throws IOException {
        this.entityName = NetworkUtil.readString(stream);
        this.style = new EntityStyle().width(stream.readInt()).height(stream.readInt()).scale(stream.readFloat());
        this.entityNbt = stream.readBoolean() ? NetworkUtil.readNBT(stream) : null;
        this.playerID = stream.readBoolean() ? Integer.valueOf(stream.readInt()) : null;
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        NetworkUtil.writeString(stream, this.entityName);
        stream.writeInt(this.style.getWidth());
        stream.writeInt(this.style.getHeight());
        stream.writeFloat(this.style.getScale());
        if (this.entityNbt != null) {
            stream.writeBoolean(true);
            NetworkUtil.writeNBT(stream, this.entityNbt);
        } else {
            stream.writeBoolean(false);
        }
        if (this.playerID != null) {
            stream.writeBoolean(true);
            stream.writeInt(this.playerID);
        } else {
            stream.writeBoolean(false);
        }
    }

    @Override
    public void render(int x, int y) {
        if (this.playerID != null) {
            ElementEntityRender.renderPlayer(this.entityName, this.playerID, this.style, x, y);
        } else {
            ElementEntityRender.render(this.entityName, this.entityNbt, this.style, x, y);
        }
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ENTITY;
    }
}

