/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IIconStyle;
import net.danygames2014.whatsthis.apiimpl.TheOneProbeImp;
import net.danygames2014.whatsthis.apiimpl.client.ElementIconRender;
import net.danygames2014.whatsthis.apiimpl.styles.IconStyle;
import net.danygames2014.whatsthis.network.NetworkUtil;

public class ElementIcon
implements IElement {
    private final String icon;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    private final IIconStyle style;

    public ElementIcon(String icon, int u, int v, int w, int h, IIconStyle style) {
        this.icon = icon;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.style = style;
    }

    public ElementIcon(DataInputStream stream) throws IOException {
        this.icon = NetworkUtil.readString(stream);
        this.u = stream.readInt();
        this.v = stream.readInt();
        this.w = stream.readInt();
        this.h = stream.readInt();
        this.style = new IconStyle().width(stream.readInt()).height(stream.readInt()).textureWidth(stream.readInt()).textureHeight(stream.readInt());
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        NetworkUtil.writeString(stream, this.icon);
        stream.writeInt(this.u);
        stream.writeInt(this.v);
        stream.writeInt(this.w);
        stream.writeInt(this.h);
        stream.writeInt(this.style.getWidth());
        stream.writeInt(this.style.getHeight());
        stream.writeInt(this.style.getTextureWidth());
        stream.writeInt(this.style.getTextureHeight());
    }

    @Override
    public void render(int x, int y) {
        ElementIconRender.render(this.icon, x, y, this.w, this.h, this.u, this.v, this.style.getTextureWidth(), this.style.getTextureHeight());
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ICON;
    }
}

