/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.providers.block;

import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IBlockDisplayOverride;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeHitData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProbeInfoProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeConfig;
import net.danygames2014.whatsthis.apiimpl.providers.block.HarvestabilityInfo;
import net.danygames2014.whatsthis.apiimpl.providers.block.InventoryInfo;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.minecraft.class_104;
import net.minecraft.class_124;
import net.minecraft.class_14;
import net.minecraft.class_140;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_348;
import net.minecraft.class_385;
import net.minecraft.class_4;
import net.minecraft.class_408;
import net.minecraft.class_444;
import net.minecraft.class_460;
import net.minecraft.class_510;
import net.minecraft.class_530;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_620;
import net.minecraft.class_88;
import net.modificationstation.stationapi.api.block.BlockState;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    private static final String[] NOTE_TABLE = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};

    @Override
    public String getID() {
        return WhatsThis.NAMESPACE.id("block_default").toString();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, BlockState state, IProbeHitData data) {
        class_17 block = state.getBlock();
        class_339 pos = data.getPos();
        ProbeConfig config = ConfigSetup.getProbeConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : WhatsThis.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, state, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(mode, probeInfo, world, pos, state, block, player, data, config);
        }
        if (block instanceof class_385) {
            return;
        }
        boolean showHarvestLevel = Util.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Util.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestabilityInfo.showHarvestInfo(probeInfo, world, pos, state, block, player);
        } else if (showHarvestLevel) {
            HarvestabilityInfo.showHarvestLevel(probeInfo, world, pos, state, block);
        } else if (showHarvested) {
            HarvestabilityInfo.showCanBeHarvested(probeInfo, world, pos, state, block, player);
        }
        if (Util.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, world, pos, state, block, data);
        }
        if (Util.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, pos, state, block, data);
        }
        if (Util.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, pos, state, block, data, Util.show(mode, config.getShowLeverSetting()));
        }
        if (Util.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, pos, state, block, data);
        }
        if (Util.show(mode, config.getShowChestContents())) {
            InventoryInfo.showInventoryInfo(mode, probeInfo, world, pos, state, block, data, config);
        }
        if (Util.show(mode, config.getShowMusicBlock())) {
            this.showMusicBlock(probeInfo, world, pos, state, block, data);
        }
        if (Util.show(mode, config.getShowSignText())) {
            this.showSignText(probeInfo, world, pos, state, block, data);
        }
    }

    public static void showStandardBlockInfo(ProbeMode mode, IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, class_54 player, IProbeHitData data, IProbeConfig config) {
        String modid = Util.getModName(block);
        class_31 pickBlock = data.getPickBlock();
        if (pickBlock != null) {
            if (Util.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(String.valueOf((Object)TextStyleClass.MODNAME) + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Util.show(mode, config.getShowModName())) {
            probeInfo.vertical().text(String.valueOf((Object)TextStyleClass.NAME) + block.method_1596()).text(String.valueOf((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.vertical().text(String.valueOf((Object)TextStyleClass.NAME) + block.method_1596());
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data) {
        class_55 class_552;
        if (block instanceof class_620 && (class_552 = world.method_1777(data.getPos().field_2100, data.getPos().field_2101, data.getPos().field_2102)) instanceof class_104) {
            class_104 spawner = (class_104)class_552;
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(String.valueOf((Object)TextStyleClass.LABEL) + "Entity: " + String.valueOf((Object)TextStyleClass.INFO) + spawner.field_2684);
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data, boolean showLever) {
        int redstonePower;
        if (showLever && block instanceof class_530) {
            return;
        }
        if (block instanceof class_408) {
            redstonePower = world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102);
        } else {
            int n = redstonePower = world.method_265(pos.field_2100, pos.field_2101, pos.field_2102) ? 15 : 0;
        }
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new class_31(class_124.field_403), probeInfo.defaultItemStyle().width(14).height(14)).text(String.valueOf((Object)TextStyleClass.LABEL) + "Power: " + String.valueOf((Object)TextStyleClass.INFO) + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data) {
        if (block instanceof class_530) {
            class_530 lever = (class_530)block;
            boolean powered = lever.method_1568((class_14)world, pos.field_2100, pos.field_2101, pos.field_2102, 0);
            probeInfo.horizontal().item(new class_31(class_124.field_403), probeInfo.defaultItemStyle().width(14).height(14)).text(String.valueOf((Object)TextStyleClass.LABEL) + "State: " + String.valueOf((Object)TextStyleClass.INFO) + (powered ? "On" : "Off"));
        } else if (block instanceof class_510) {
            int delay = ((world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102) & 0xC) >> 2) + 1;
            probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Delay: " + String.valueOf((Object)TextStyleClass.INFO) + delay + " ticks");
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        if (blockState.isOf(class_17.field_1848)) {
            int maxAge;
            int age = world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102);
            if (age == (maxAge = 7)) {
                probeInfo.text(String.valueOf((Object)TextStyleClass.OK) + "Fully grown");
            } else {
                probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Growth: " + String.valueOf((Object)TextStyleClass.WARNING) + age * 100 / maxAge + "%");
            }
        }
    }

    private void showMusicBlock(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        class_55 note2;
        class_55 class_552;
        if (block instanceof class_348 && (class_552 = world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102)) instanceof class_444) {
            class_444 noteBlock = (class_444)class_552;
            byte note2 = noteBlock.field_1699;
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(String.valueOf((Object)TextStyleClass.LABEL) + "Note: " + String.valueOf((Object)TextStyleClass.INFO) + NOTE_TABLE[note2]);
        } else if (block instanceof class_88 && (note2 = world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102)) instanceof class_4) {
            class_4 jukebox = (class_4)note2;
            class_31 disc = new class_31(jukebox.field_4, 1, 0);
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(disc).itemLabel(disc);
        }
    }

    private void showSignText(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        class_55 class_552;
        if (block instanceof class_460 && (class_552 = world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102)) instanceof class_140) {
            class_140 sign = (class_140)class_552;
            probeInfo.vertical(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(sign.field_2269[0]).text(sign.field_2269[1]).text(sign.field_2269[2]).text(sign.field_2269[3]);
        }
    }
}

