/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IOverlayStyle;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeConfig;
import net.danygames2014.whatsthis.apiimpl.styles.DefaultOverlayStyle;
import net.danygames2014.whatsthis.config.Config;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import org.apache.commons.lang3.StringUtils;

public class ConfigSetup {
    public static final int PROBE_NOTNEEDED = 0;
    public static final int PROBE_NEEDED = 1;
    public static final int PROBE_NEEDEDHARD = 2;
    public static final int PROBE_NEEDEDFOREXTENDED = 3;
    private static Set<Identifier> inventoriesToShow = null;
    private static Set<Identifier> inventoriesToNotShow = null;
    private static Set<Identifier> dontSendNBTSet = null;
    public static Map<TextStyleClass, String> defaultTextStyleClasses = new HashMap<TextStyleClass, String>();
    public static Map<TextStyleClass, String> textStyleClasses = new HashMap<TextStyleClass, String>();
    private static IOverlayStyle defaultOverlayStyle;
    private static ProbeConfig probeConfig;

    public static ProbeConfig getProbeConfig() {
        return probeConfig;
    }

    public static void setProbeConfig(IProbeConfig config) {
        probeConfig = (ProbeConfig)config;
    }

    public static void setTextStyle(Map<TextStyleClass, String> defaultStyle, Map<TextStyleClass, String> style) {
        HashMap<String, Object> toSave = new HashMap<String, Object>();
        textStyleClasses.putAll(defaultStyle);
        for (Map.Entry<TextStyleClass, String> styleClass : defaultStyle.entrySet()) {
            toSave.put("textStyle" + styleClass.getKey().getReadableName(), styleClass.getValue());
        }
        textStyleClasses.putAll(style);
        for (Map.Entry<TextStyleClass, String> styleClass : style.entrySet()) {
            toSave.put("textStyle" + styleClass.getKey().getReadableName(), styleClass.getValue());
        }
        ConfigSetup.setConfigValues("whatsthis:client", toSave);
    }

    public static void setTextStyle(Map<TextStyleClass, String> style) {
        HashMap<String, Object> toSave = new HashMap<String, Object>();
        textStyleClasses.putAll(style);
        for (Map.Entry<TextStyleClass, String> styleClass : style.entrySet()) {
            toSave.put("textStyle" + styleClass.getKey().getReadableName(), styleClass.getValue());
        }
        ConfigSetup.setConfigValues("whatsthis:client", toSave);
    }

    public static void setConfigValue(String configId, String key, Object value) {
        GlassYamlFile yamlFile = new GlassYamlFile();
        yamlFile.set(key, value);
        GCAPI.reloadConfig((String)configId, (GlassYamlFile)yamlFile);
    }

    public static void setConfigValues(String configId, HashMap<String, Object> values) {
        GlassYamlFile yamlFile = new GlassYamlFile();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            yamlFile.set(entry.getKey(), entry.getValue());
        }
        GCAPI.reloadConfig((String)configId, (GlassYamlFile)yamlFile);
    }

    public static void setProbeNeeded(int needsProbe) {
        ConfigSetup.setConfigValue("whatsthis:config", "needsProbe", needsProbe);
    }

    public static void setLiquids(boolean showLiquids) {
        ConfigSetup.setConfigValue("whatsthis:client", "showLiquids", showLiquids);
    }

    public static void setVisible(boolean isVisible) {
        ConfigSetup.setConfigValue("whatsthis:client", "isVisible", isVisible);
    }

    public static void setPos(final int leftx, final int topy, final int rightx, final int bottomy) {
        ConfigSetup.setConfigValues("whatsthis:client", new HashMap<String, Object>(){
            {
                this.put("leftX", leftx);
                this.put("topY", topy);
                this.put("rightX", rightx);
                this.put("bottomY", bottomy);
            }
        });
        ConfigSetup.updateDefaultOverlayStyle();
    }

    public static void setTooltipScale(float scale) {
        scale = MathHelper.clamp((float)scale, (float)0.75f, (float)2.5f);
        System.err.println(scale);
        ConfigSetup.setConfigValue("whatsthis:client", "tooltipScale", Float.valueOf(scale));
        ConfigSetup.updateDefaultOverlayStyle();
    }

    public static void setBoxStyle(final int thickness, final int borderColor, final int fillcolor, final int offset) {
        ConfigSetup.setConfigValues("whatsthis:client", new HashMap<String, Object>(){
            {
                this.put("boxThickness", thickness);
                this.put("boxBorderColor", Integer.toHexString(borderColor));
                this.put("boxFillColor", Integer.toHexString(fillcolor));
                this.put("boxOffset", offset);
            }
        });
        ConfigSetup.updateDefaultOverlayStyle();
    }

    private static String convertFormatting(String input) {
        switch (input) {
            case "black": {
                return Formatting.BLACK.toString();
            }
            case "dark_blue": {
                return Formatting.DARK_BLUE.toString();
            }
            case "dark_green": {
                return Formatting.DARK_GREEN.toString();
            }
            case "dark_aqua": {
                return Formatting.DARK_AQUA.toString();
            }
            case "dark_red": {
                return Formatting.DARK_RED.toString();
            }
            case "dark_purple": {
                return Formatting.DARK_PURPLE.toString();
            }
            case "gold": {
                return Formatting.GOLD.toString();
            }
            case "gray": {
                return Formatting.GRAY.toString();
            }
            case "dark_gray": {
                return Formatting.DARK_GRAY.toString();
            }
            case "blue": {
                return Formatting.BLUE.toString();
            }
            case "green": {
                return Formatting.GREEN.toString();
            }
            case "aqua": {
                return Formatting.AQUA.toString();
            }
            case "red": {
                return Formatting.RED.toString();
            }
            case "light_purple": {
                return Formatting.LIGHT_PURPLE.toString();
            }
            case "yellow": {
                return Formatting.YELLOW.toString();
            }
            case "white": {
                return Formatting.WHITE.toString();
            }
            case "bold": {
                return "\u00a7l";
            }
            case "italic": {
                return "\u00a7o";
            }
            case "underline": {
                return "\u00a7n";
            }
            case "strikethrough": {
                return "\u00a7m";
            }
            case "obfuscated": {
                return "\u00a7k";
            }
        }
        WhatsThis.LOGGER.warn("Unhandled formatting: " + input);
        return Formatting.WHITE.toString();
    }

    private static String configToTextFormat(String input) {
        String[] splitted;
        if ("context".equals(input)) {
            return "context";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : splitted = StringUtils.split((String)input, (char)',')) {
            String format = ConfigSetup.convertFormatting(s);
            if (format == null) continue;
            builder.append(format);
        }
        return builder.toString();
    }

    public static String getTextStyle(TextStyleClass styleClass) {
        if (textStyleClasses.containsKey((Object)styleClass)) {
            return ConfigSetup.configToTextFormat(textStyleClasses.get((Object)styleClass));
        }
        return "";
    }

    public static void updateDefaultOverlayStyle() {
        defaultOverlayStyle = new DefaultOverlayStyle().borderThickness(Config.CLIENT_CONFIG.boxThickness).borderColor(Config.parseColor(Config.CLIENT_CONFIG.boxBorderColor)).boxColor(Config.parseColor(Config.CLIENT_CONFIG.boxFillColor)).borderOffset(Config.CLIENT_CONFIG.boxOffset).location(Config.CLIENT_CONFIG.leftX, Config.CLIENT_CONFIG.rightX, Config.CLIENT_CONFIG.topY, Config.CLIENT_CONFIG.bottomY);
    }

    public static IOverlayStyle getDefaultOverlayStyle() {
        if (defaultOverlayStyle == null) {
            ConfigSetup.updateDefaultOverlayStyle();
        }
        return defaultOverlayStyle;
    }

    public static Set<Identifier> getInventoriesToShow() {
        if (inventoriesToShow == null) {
            inventoriesToShow = new HashSet<Identifier>();
            for (String s : Config.PROBE_CONFIG.showContentsWithoutSneaking) {
                inventoriesToShow.add(Identifier.of((String)s));
            }
        }
        return inventoriesToShow;
    }

    public static Set<Identifier> getInventoriesToNotShow() {
        if (inventoriesToNotShow == null) {
            inventoriesToNotShow = new HashSet<Identifier>();
            for (String s : Config.PROBE_CONFIG.dontShowContentsUnlessSneaking) {
                inventoriesToNotShow.add(Identifier.of((String)s));
            }
        }
        return inventoriesToNotShow;
    }

    public static Set<Identifier> getDontSendNBTSet() {
        if (dontSendNBTSet == null) {
            dontSendNBTSet = new HashSet<Identifier>();
            for (String s : Config.PROBE_CONFIG.dontSendNBT) {
                dontSendNBTSet.add(Identifier.of((String)s));
            }
        }
        return dontSendNBTSet;
    }

    static {
        defaultTextStyleClasses.put(TextStyleClass.NAME, "white");
        defaultTextStyleClasses.put(TextStyleClass.MODNAME, "blue");
        defaultTextStyleClasses.put(TextStyleClass.ERROR, "red,bold");
        defaultTextStyleClasses.put(TextStyleClass.WARNING, "yellow");
        defaultTextStyleClasses.put(TextStyleClass.OK, "green");
        defaultTextStyleClasses.put(TextStyleClass.INFO, "white");
        defaultTextStyleClasses.put(TextStyleClass.INFOIMP, "blue");
        defaultTextStyleClasses.put(TextStyleClass.OBSOLETE, "gray,strikethrough");
        defaultTextStyleClasses.put(TextStyleClass.LABEL, "gray");
        defaultTextStyleClasses.put(TextStyleClass.PROGRESS, "white");
        textStyleClasses = new HashMap<TextStyleClass, String>(defaultTextStyleClasses);
        probeConfig = new ProbeConfig();
    }
}

