/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IOverlayStyle;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.gui.HitBox;
import net.danygames2014.whatsthis.gui.Preset;
import net.danygames2014.whatsthis.rendering.RenderHelper;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.modificationstation.stationapi.api.util.Formatting;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ConfigScreen
extends class_32 {
    private static final int WIDTH = 230;
    private static final int HEIGHT = 230;
    private int guiLeft;
    private int guiTop;
    private static final String background = "assets/whatsthis/stationapi/textures/gui/config.png";
    private static final String scene = "assets/whatsthis/stationapi/textures/gui/scene.png";
    private static int backgroundId = 0;
    private static int sceneId = 0;
    private static final List<Preset> presets = new ArrayList<Preset>();
    private List<HitBox> hitboxes = Collections.emptyList();

    public boolean method_121() {
        return false;
    }

    public void method_119() {
        super.method_119();
        this.guiLeft = (this.field_152 - 230 - 230) / 2;
        this.guiTop = (this.field_153 - 230) / 2;
        backgroundId = this.field_151.field_2814.method_1100(background);
        sceneId = this.field_151.field_2814.method_1100(scene);
    }

    public void method_118(int mouseX, int mouseY, float partialTicks) {
        super.method_118(mouseX, mouseY, partialTicks);
        this.field_151.field_2814.method_1097(backgroundId);
        this.method_1936(this.guiLeft + 230, this.guiTop, 0, 0, 230, 230);
        this.field_151.field_2814.method_1097(sceneId);
        this.method_1936(this.guiLeft, this.guiTop, 0, 0, 230, 230);
        this.renderProbe();
        int x = 230 + this.guiLeft + 10;
        int y = this.guiTop + 10;
        RenderHelper.renderText(this.field_151, x, y, String.valueOf(Formatting.GOLD) + "Placement:");
        RenderHelper.renderText(this.field_151, x + 10, y += 12, "Click on corner in screenshot");
        RenderHelper.renderText(this.field_151, x + 10, y += 10, "to move tooltip there");
        this.hitboxes = new ArrayList<HitBox>();
        RenderHelper.renderText(this.field_151, x, y += 20, String.valueOf(Formatting.GOLD) + "Presets:");
        y += 12;
        for (Preset preset : presets) {
            y = this.addPreset(x, y, preset);
        }
        RenderHelper.renderText(this.field_151, x, y += 10, String.valueOf(Formatting.GOLD) + "Scale:");
        this.addButton(x + 10, y += 12, 30, 14, " --", () -> ConfigSetup.setTooltipScale(Config.CLIENT_CONFIG.tooltipScale.floatValue() + 0.2f));
        this.addButton((x += 36) + 10, y, 30, 14, "  -", () -> ConfigSetup.setTooltipScale(Config.CLIENT_CONFIG.tooltipScale.floatValue() + 0.1f));
        this.addButton((x += 36) + 10, y, 30, 14, "  0", () -> ConfigSetup.setTooltipScale(1.0f));
        this.addButton((x += 36) + 10, y, 30, 14, "  +", () -> ConfigSetup.setTooltipScale(Config.CLIENT_CONFIG.tooltipScale.floatValue() - 0.1f));
        this.addButton((x += 36) + 10, y, 30, 14, "  ++", () -> ConfigSetup.setTooltipScale(Config.CLIENT_CONFIG.tooltipScale.floatValue() - 0.2f));
        int margin = 90;
        this.hitboxes.add(new HitBox(0, 0, margin, margin, () -> ConfigSetup.setPos(5, 5, -1, -1)));
        this.hitboxes.add(new HitBox(margin, 0, 230 - margin, margin, () -> ConfigSetup.setPos(-1, 5, -1, -1)));
        this.hitboxes.add(new HitBox(230 - margin, 0, 230, margin, () -> ConfigSetup.setPos(-1, 5, 5, -1)));
        this.hitboxes.add(new HitBox(0, margin, margin, 230 - margin, () -> ConfigSetup.setPos(5, -1, -1, -1)));
        this.hitboxes.add(new HitBox(margin, margin, 230 - margin, 230 - margin, () -> ConfigSetup.setPos(-1, -1, -1, -1)));
        this.hitboxes.add(new HitBox(230 - margin, margin, 230, 230 - margin, () -> ConfigSetup.setPos(-1, -1, 5, -1)));
        this.hitboxes.add(new HitBox(0, 230 - margin, margin, 230, () -> ConfigSetup.setPos(5, -1, -1, 5)));
        this.hitboxes.add(new HitBox(margin, 230 - margin, 230 - margin, 230, () -> ConfigSetup.setPos(-1, -1, -1, 20)));
        this.hitboxes.add(new HitBox(230 - margin, 230 - margin, 230, 230, () -> ConfigSetup.setPos(-1, -1, 5, 5)));
    }

    protected void method_124(int mouseX, int mouseY, int mouseButton) {
        super.method_124(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (HitBox box : this.hitboxes) {
                if (!box.isHit(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
                box.call();
            }
        }
    }

    private void applyPreset(Preset preset) {
        ConfigSetup.setBoxStyle(preset.getBoxThickness(), preset.getBoxBorderColor(), preset.getBoxFillColor(), preset.getBoxOffset());
        ConfigSetup.setTextStyle(ConfigSetup.defaultTextStyleClasses, preset.getTextStyleClasses());
    }

    private int addPreset(int x, int y, Preset preset) {
        this.method_1932(x + 10, y - 1, x + 10 + 230 - 50, y + 10, -16777216);
        RenderHelper.renderText(this.field_151, x + 20, y, preset.getName());
        this.hitboxes.add(new HitBox(x + 10 - this.guiLeft, y - 1 - this.guiTop, x + 10 + 230 - 50 - this.guiLeft, y + 10 - this.guiTop, () -> this.applyPreset(preset)));
        return y += 14;
    }

    private void addButton(int x, int y, int width, int height, String text, Runnable runnable) {
        this.method_1932(x, y, x + width - 1, y + height - 1, -16777216);
        RenderHelper.renderText(this.field_151, x + 3, y + 3, text);
        this.hitboxes.add(new HitBox(x - this.guiLeft, y - this.guiTop, x + width - 1 - this.guiLeft, y + height - 1 - this.guiTop, runnable));
    }

    private void renderProbe() {
        class_17 block = class_17.field_1831;
        String modid = Util.getModName(block);
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        class_31 pickBlock = new class_31(block);
        probeInfo.horizontal().item(pickBlock).vertical().text(String.valueOf((Object)TextStyleClass.NAME) + pickBlock.method_694().method_469()).text(String.valueOf((Object)TextStyleClass.MODNAME) + modid);
        probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Fuel: " + String.valueOf((Object)TextStyleClass.INFO) + "5 volts");
        probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Error: " + String.valueOf((Object)TextStyleClass.ERROR) + "Oups!");
        this.renderElements(probeInfo, ConfigSetup.getDefaultOverlayStyle());
    }

    private void renderElements(ProbeInfo probeInfo, IOverlayStyle style) {
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()), (float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()), (float)(1.0f / Config.CLIENT_CONFIG.tooltipScale.floatValue()));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = this.calculateXPosition(style, w);
        int y = this.calculateYPosition(style, h);
        x += this.guiLeft;
        y += this.guiTop;
        double factor = (double)(Config.CLIENT_CONFIG.tooltipScale.floatValue() - 1.0f) * 1.4 + 1.0;
        x = (int)((double)x * factor);
        y = (int)((double)y * factor);
        if (thick > 0) {
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(x, y, x2, y2, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(x + offset, y + offset, x2 - offset, y2 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!this.field_151.field_2813) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(x + margin, y + margin);
        GL11.glPopMatrix();
    }

    private int calculateXPosition(IOverlayStyle style, int width) {
        if (style.getLeftX() != -1) {
            return style.getLeftX();
        }
        if (style.getRightX() != -1) {
            return 230 - width - style.getRightX();
        }
        return (230 - width) / 2;
    }

    private int calculateYPosition(IOverlayStyle style, int height) {
        if (style.getTopY() != -1) {
            return style.getTopY();
        }
        if (style.getBottomY() != -1) {
            return 230 - height - style.getBottomY();
        }
        return (230 - height) / 2;
    }

    static {
        presets.add(new Preset("Default", -6710887, 1426089625, 2, 0, new Pair[0]));
        presets.add(new Preset("WAILA", -12254256, -16777216, 1, 1, new Pair[0]));
        presets.add(new Preset("Jade", -13487311, -14670310, 1, 1, new Pair[0]));
        presets.add(new Preset("Full transparent", 0, 0, 0, 0, new Pair[0]));
        presets.add(new Preset("Black & White", -1, -16777216, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"white,italic"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"white,underline"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"white,strikethrough"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"white,underline"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white")));
        presets.add(new Preset("Soft Pastels", -2049025, 0, 1, 1, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"aqua")));
        presets.add(new Preset("Ocean Blue", -16764058, 1432787404, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"cyan"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"light_blue,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"yellow,bold"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"red,bold"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"gray,bold,italic"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"aqua,bold"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"green,bold"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white,bold")));
    }
}

