/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeConfigProvider;
import net.danygames2014.whatsthis.api.IProbeInfoEntityProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeHitEntityData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.danygames2014.whatsthis.network.PacketReturnEntityInfo;
import net.danygames2014.whatsthis.network.ThrowableIdentity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import org.jetbrains.annotations.NotNull;

public class PacketGetEntityInfo
extends class_169
implements ManagedPacket<PacketGetEntityInfo> {
    public static final PacketType<PacketGetEntityInfo> TYPE = PacketType.builder((boolean)false, (boolean)true, PacketGetEntityInfo::new).build();
    private int dim;
    private int entityId;
    private ProbeMode mode;
    private class_26 hitVec;
    private int size;

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, class_27 mouseOver, class_57 entity) {
        this.dim = dim;
        this.entityId = entity.field_1591;
        this.mode = mode;
        this.hitVec = class_26.method_1293((double)mouseOver.field_1984, (double)mouseOver.field_1985, (double)mouseOver.field_1986);
    }

    public void method_806(DataInputStream stream) {
        try {
            this.dim = stream.readInt();
            this.entityId = stream.readInt();
            this.mode = ProbeMode.values()[stream.readByte()];
            if (stream.readBoolean()) {
                this.hitVec = class_26.method_1293((double)stream.readDouble(), (double)stream.readDouble(), (double)stream.readDouble());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();
            stream.writeInt(this.dim);
            stream.writeInt(this.entityId);
            stream.writeByte(this.mode.ordinal());
            if (this.hitVec == null) {
                stream.writeBoolean(false);
            } else {
                stream.writeBoolean(true);
                stream.writeDouble(this.hitVec.field_1585);
                stream.writeDouble(this.hitVec.field_1586);
                stream.writeDouble(this.hitVec.field_1587);
            }
            this.size = stream.size() - initialStreamSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 networkHandler) {
        switch (FabricLoader.getInstance().getEnvironmentType()) {
            case CLIENT: {
                this.handleClient(networkHandler);
                break;
            }
            case SERVER: {
                this.handleServer(networkHandler);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient(class_240 networkHandler) {
        class_57 entity;
        class_18 world = Minecraft.field_2791.field_2804;
        if (world != null && (entity = Util.getEntity(world, this.entityId)) != null) {
            ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((class_54)Minecraft.field_2791.field_2806, this.mode, world, entity, this.hitVec);
            PacketHelper.sendTo((class_54)Minecraft.field_2791.field_2806, (class_169)new PacketReturnEntityInfo(this.entityId, probeInfo));
        }
    }

    @Environment(value=EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11) {
            class_57 entity;
            class_11 handler = (class_11)networkHandler;
            class_18 world = handler.field_920.field_1596;
            if (world != null && (entity = Util.getEntity(world, this.entityId)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((class_54)handler.field_920, this.mode, world, entity, this.hitVec);
                PacketHelper.sendTo((class_54)handler.field_920, (class_169)new PacketReturnEntityInfo(this.entityId, probeInfo));
            }
        }
    }

    public int method_798() {
        return this.size;
    }

    private static ProbeInfo getProbeInfo(class_54 player, ProbeMode mode, class_18 world, class_57 entity, class_26 hitVec) {
        if (Config.PROBE_CONFIG.needsProbe == 3) {
            if (!ProbeUtil.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if (Config.PROBE_CONFIG.needsProbe == 2 && !ProbeUtil.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = WhatsThis.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        ConfigSetup.setProbeConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = WhatsThis.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Error: " + String.valueOf((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }

    @NotNull
    public PacketType<PacketGetEntityInfo> getType() {
        return TYPE;
    }
}

