package net.danygames2014.whatsthis.apiimpl.providers.block;

import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.*;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.minecraft.block.*;
import net.minecraft.class_104;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_348;
import net.minecraft.class_385;
import net.minecraft.class_4;
import net.minecraft.class_408;
import net.minecraft.class_444;
import net.minecraft.class_460;
import net.minecraft.class_510;
import net.minecraft.class_530;
import net.minecraft.class_54;
import net.minecraft.class_620;
import net.minecraft.class_88;
import net.modificationstation.stationapi.api.block.BlockState;

import static net.danygames2014.whatsthis.api.TextStyleClass.*;

public class DefaultProbeInfoProvider implements IProbeInfoProvider {

    @Override
    public String getID() {
        return WhatsThis.NAMESPACE.id("block_default").toString();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, BlockState state, IProbeHitData data) {
        class_17 block = state.getBlock();
        class_339 pos = data.getPos();

        IProbeConfig config = ConfigSetup.getProbeConfig();

        // Standard Information
        boolean handled = false;
        for (IBlockDisplayOverride override : WhatsThis.theOneProbeImp.getBlockOverrides()) {
            if (override.overrideStandardInfo(mode, probeInfo, player, world, state, data)) {
                handled = true;
                break;
            }
        }

        if (!handled) {
            showStandardBlockInfo(mode, probeInfo, world, pos, state, block, player, data, config);
        }

        // If its a liquid, we don't need to do further processing
        if (block instanceof class_385) {
            return;
        }

        // Harvest Level
        boolean showHarvestLevel = Util.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Util.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestabilityInfo.showHarvestInfo(probeInfo, world, pos, state, block, player);
        } else if (showHarvestLevel) {
            HarvestabilityInfo.showHarvestLevel(probeInfo, world, pos, state, block);
        } else if (showHarvested) {
            HarvestabilityInfo.showCanBeHarvested(probeInfo, world, pos, state, block, player);
        }

        // Crop Growth
        if (Util.show(mode, config.getShowCropPercentage())) {
            showGrowthLevel(probeInfo, world, pos, state, block, data);
        }

        // Mob Spawner Info
        if (Util.show(mode, config.getShowMobSpawnerSetting())) {
            showMobSpawnerInfo(probeInfo, world, pos, state, block, data);
        }

        // Redstone Power
        if (Util.show(mode, config.getShowRedstone())) {
            showRedstonePower(probeInfo, world, pos, state, block, data, Util.show(mode, config.getShowLeverSetting()));
        }

        // Redstone Component
        if (Util.show(mode, config.getShowLeverSetting())) {
            showLeverSetting(probeInfo, world, pos, state, block, data);
        }

        // Inventory Contents
        if (Util.show(mode, config.getShowChestContents())) {
            InventoryInfo.showInventoryInfo(mode, probeInfo, world, pos, state, block, data, config);
        }

        // Note Block Info
        if (Util.show(mode, config.getShowMusicBlock())) {
            showMusicBlock(probeInfo, world, pos, state, block, data);
        }

        if (Util.show(mode, config.getShowSignText())) {
            showSignText(probeInfo, world, pos, state, block, data);
        }

        // Energy Info
//        if (config.getRFMode() > 0) {
//            showRF(probeInfo, world, pos);
//        }

        // Fluid Info
//        if (Util.show(mode, config.getShowTankSetting())) {
//            if (config.getTankMode() > 0) {
//                showTankInfo(probeInfo, world, pos);
//            }
//        }
    }

    public static void showStandardBlockInfo(ProbeMode mode, IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, class_54 player, IProbeHitData data, IProbeConfig config) {
        String modid = Util.getModName(block);
        class_31 pickBlock = data.getPickBlock();

        // TODO: Special handling for liquids when the time comes

        if (pickBlock != null) {
            if (Util.show(mode, config.getShowModName())) {
                probeInfo.horizontal()
                        .item(pickBlock)
                        .vertical()
                        .itemLabel(pickBlock)
                        .text(MODNAME + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER))
                        .item(pickBlock)
                        .itemLabel(pickBlock);
            }
        } else {
            if (Util.show(mode, config.getShowModName())) {
                probeInfo.vertical()
                        .text(NAME + block.method_1596())
                        .text(MODNAME + modid);
            } else {
                probeInfo.vertical()
                        .text(NAME + block.method_1596());
            }
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data) {
        if (block instanceof class_620) {
            if (world.method_1777(data.getPos().field_2100, data.getPos().field_2101, data.getPos().field_2102) instanceof class_104 spawner) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle()
                                .alignment(ElementAlignment.ALIGN_CENTER))
                        .text(LABEL + "Entity: " + INFO + spawner.field_2684);
            }
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data, boolean showLever) {
        if (showLever && block instanceof class_530) {
            // We are showing the lever setting so we don't show redstone in that case
            return;
        }

        int redstonePower;

        if (block instanceof class_408) {
            redstonePower = world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102);
        } else {
            redstonePower = world.method_265(pos.field_2100, pos.field_2101, pos.field_2102) ? 15 : 0;
        }

        if (redstonePower > 0) {
            probeInfo.horizontal()
                    .item(new class_31(class_124.field_403), probeInfo.defaultItemStyle().width(14).height(14))
                    .text(LABEL + "Power: " + INFO + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, IProbeHitData data) {
        if (block instanceof class_530 lever) {
            boolean powered = lever.method_1568(world, pos.field_2100, pos.field_2101, pos.field_2102, 0);
            probeInfo.horizontal().item(new class_31(class_124.field_403), probeInfo.defaultItemStyle().width(14).height(14))
                    .text(LABEL + "State: " + INFO + (powered ? "On" : "Off"));

        } else if (block instanceof class_510) {
            int delay = ((world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102) & 12) >> 2) + 1;
            probeInfo.text(LABEL + "Delay: " + INFO + delay + " ticks");
        }
    }

//    private void showTankInfo(IProbeInfo probeInfo, World world, BlockPos pos) {
//        ProbeConfig config = ConfigSetup.getDefaultConfig();
//        TileEntity te = world.getTileEntity(pos);
//        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
//            net.minecraftforge.fluids.capability.IFluidHandler handler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
//            if (handler != null) {
//                IFluidTankProperties[] properties = handler.getTankProperties();
//                if (properties != null) {
//                    for (IFluidTankProperties property : properties) {
//                        if (property != null) {
//                            FluidStack fluidStack = property.getContents();
//                            int maxContents = property.getCapacity();
//                            addFluidInfo(probeInfo, config, fluidStack, maxContents);
//                        }
//                    }
//                }
//            }
//        }
//    }

//    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
//        int contents = fluidStack == null ? 0 : fluidStack.amount;
//        if (fluidStack != null) {
//            probeInfo.text(NAME + "Liquid: " + fluidStack.getLocalizedName());
//        }
//        if (config.getTankMode() == 1) {
//            probeInfo.progress(contents, maxContents,
//                    probeInfo.defaultProgressStyle()
//                            .suffix("mB")
//                            .filledColor(ConfigSetup.tankbarFilledColor)
//                            .alternateFilledColor(ConfigSetup.tankbarAlternateFilledColor)
//                            .borderColor(ConfigSetup.tankbarBorderColor)
//                            .numberFormat(ConfigSetup.tankFormat));
//        } else {
//            probeInfo.text(PROGRESS + ElementProgress.format(contents, ConfigSetup.tankFormat, "mB"));
//        }
//    }

//    private void showRF(IProbeInfo probeInfo, World world, BlockPos pos) {
//        ProbeConfig config = ConfigSetup.getDefaultConfig();
//        TileEntity te = world.getTileEntity(pos);
//        if (ModSetup.tesla && TeslaTools.isEnergyHandler(te)) {
//            long energy = TeslaTools.getEnergy(te);
//            long maxEnergy = TeslaTools.getMaxEnergy(te);
//            addRFInfo(probeInfo, config, energy, maxEnergy);
//        } else if (te instanceof IBigPower) {
//            long energy = ((IBigPower) te).getStoredPower();
//            long maxEnergy = ((IBigPower) te).getCapacity();
//            addRFInfo(probeInfo, config, energy, maxEnergy);
//        } else if (ModSetup.redstoneflux && RedstoneFluxTools.isEnergyHandler(te)) {
//            int energy = RedstoneFluxTools.getEnergy(te);
//            int maxEnergy = RedstoneFluxTools.getMaxEnergy(te);
//            addRFInfo(probeInfo, config, energy, maxEnergy);
//        } else if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
//            net.minecraftforge.energy.IEnergyStorage handler = te.getCapability(CapabilityEnergy.ENERGY, null);
//            if (handler != null) {
//                addRFInfo(probeInfo, config, handler.getEnergyStored(), handler.getMaxEnergyStored());
//            }
//        }
//    }

//    private void addRFInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
//        if (config.getRFMode() == 1) {
//            probeInfo.progress(energy, maxEnergy,
//                    probeInfo.defaultProgressStyle()
//                            .suffix("RF")
//                            .filledColor(Config.parseColor(Config.MAIN_CONFIG.rfbarFilledColor))
//                            .alternateFilledColor(Config.parseColor(Config.MAIN_CONFIG.rfbarAlternateFilledColor))
//                            .borderColor(Config.parseColor(Config.MAIN_CONFIG.rfbarBorderColor))
//                            .numberFormat(Config.MAIN_CONFIG.rfFormat));
//        } else {
//            probeInfo.text(PROGRESS + "RF: " + ElementProgress.format(energy, Config.MAIN_CONFIG.rfFormat, "RF"));
//        }
//    }

    private void showGrowthLevel(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        if (blockState.isOf(class_17.field_1848)) {
            int age = world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102);
            int maxAge = 7;

            if (age == maxAge) {
                probeInfo.text(OK + "Fully grown");
            } else {
                probeInfo.text(LABEL + "Growth: " + WARNING + (age * 100) / maxAge + "%");
            }
        }
    }

    private static final String[] NOTE_TABLE = {
            "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"
    };

    private void showMusicBlock(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        if (block instanceof class_348 && world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102) instanceof class_444 noteBlock) {
            byte note = noteBlock.field_1699;

            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER))
                    .text(LABEL + "Note: " + INFO + NOTE_TABLE[note]);


        } else if (block instanceof class_88 && world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102) instanceof class_4 jukebox) {
            var disc = new class_31(jukebox.field_4, 1, 0);

            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER))
                    .item(disc)
                    .itemLabel(disc);

        }
    }

    private void showSignText(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState blockState, class_17 block, IProbeHitData data) {
        if (block instanceof class_460 && world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102) instanceof class_140 sign) {
            probeInfo.vertical(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER))
                    .text(sign.field_2269[0])
                    .text(sign.field_2269[1])
                    .text(sign.field_2269[2])
                    .text(sign.field_2269[3]);
        }
    }


}
