package net.danygames2014.whatsthis.apiimpl.providers.block;

import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IIconStyle;
import net.danygames2014.whatsthis.api.ILayoutStyle;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_352;
import net.minecraft.class_54;
import net.minecraft.class_632;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.tool.TagToolLevel;
import net.modificationstation.stationapi.api.item.tool.ToolLevel;
import net.modificationstation.stationapi.api.tag.TagKey;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import static net.danygames2014.whatsthis.api.TextStyleClass.*;

public class HarvestabilityInfo {

    private static final String ICONS = "assets/whatsthis/stationapi/textures/gui/icons.png";

    // Harvest Levels
    private record HarvestLevelEntry(String name, TagKey<class_17> tagKey, ToolLevel toolLevel) {
    }

    private static ArrayList<HarvestLevelEntry> HARVEST_LEVELS = null;
    private static final HashMap<BlockState, String> harvestLevelCache = new HashMap<>();

    @SuppressWarnings("UnstableApiUsage")
    private static void getToolLevels() {
        if (HARVEST_LEVELS != null) {
            return;
        }

        HARVEST_LEVELS = new ArrayList<>();

        // Find lowest node ?
        ToolLevel currentLevel = (ToolLevel) ToolLevel.ALL_LEVELS.toArray()[0];
        boolean run = true;

        while (run) {
            Set<ToolLevel> predecessors = ToolLevel.GRAPH.predecessors(currentLevel);

            if (!predecessors.isEmpty()) {
                currentLevel = (ToolLevel) predecessors.toArray()[0];
            } else {
                run = false;
            }
        }

        // Now go up ?
        run = true;

        while (run) {
            if (currentLevel instanceof TagToolLevel tagToolLevel) {
                String name = tagToolLevel.tag.id().path;
                String[] split = tagToolLevel.tag.id().path.split("_");
                if (split.length > 0) {
                    name = split[split.length - 2];
                    name = StringUtils.capitalize(name);
                }
                HARVEST_LEVELS.add(new HarvestLevelEntry(name, tagToolLevel.tag, tagToolLevel));
            } else {
                HARVEST_LEVELS.add(new HarvestLevelEntry(currentLevel.toString(), null, currentLevel));
            }

            var successors = ToolLevel.GRAPH.successors(currentLevel);
            if (!successors.isEmpty()) {
                currentLevel = (ToolLevel) successors.toArray()[0];
            } else {
                run = false;
            }
        }
    }

    private static String getHarvestLevel(BlockState state) {
        getToolLevels();
        return harvestLevelCache.computeIfAbsent(state, HarvestabilityInfo::computeHarvestLevel);

    }

    private static String computeHarvestLevel(BlockState state) {
        for (HarvestLevelEntry entry : HARVEST_LEVELS) {
            if (ToolLevel.isSuitable(entry.toolLevel, state)) {
                return entry.name;
            }
        }

        return "";
    }

    // Harvest Tools
    private static final HashMap<BlockState, String> harvestToolCache = new HashMap<>();
    private static final HashMap<String, class_31> testTools = new HashMap<>();

    static {
        testTools.put("Shovel", new class_31(class_124.field_490));
        testTools.put("Axe", new class_31(class_124.field_376));
        testTools.put("Pickaxe", new class_31(class_124.field_491));
        testTools.put("Hoe", new class_31(class_124.field_390));
        testTools.put("Sword", new class_31(class_124.field_489));
        testTools.put("Shears", new class_31(class_124.field_458));
    }

    private static String getHarvestTool(class_18 world, class_339 pos, BlockState state, class_17 block) {
        if (!harvestToolCache.containsKey(state)) {
            harvestToolCache.put(state, computeHarvestTools(world, pos, state, block));
        }

        return harvestToolCache.get(state);
    }

    private static String computeHarvestTools(class_18 world, class_339 pos, BlockState state, class_17 block) {
        String harvestTool = null;

        // The block doesn't have an explicitly-set harvest tool, so we're going to test our tools against the block.
        float blockHardness = state.getHardness(world, pos);
        if (blockHardness > 0f) {
            for (Map.Entry<String, class_31> testToolEntry : testTools.entrySet()) {
                // loop through our test tools until we find a winner.
                class_31 testTool = testToolEntry.getValue();

                if (testTool != null) {
                    // First check if it is a tool
                    if (testTool.method_694() instanceof class_632 toolItem) {
                        if (testTool.method_708(block) >= toolItem.field_2711.method_1418()) {
                            return testToolEntry.getKey();
                        }
                        // Then check if it is a sword which has a base mining speed multiplier of 1.5F
                    } else if (testTool.method_694() instanceof class_352) {
                        if (testTool.method_708(block) > 1.5F) {
                            return testToolEntry.getKey();
                        }

                        // Finally check for other items
                    } else if (testTool.method_708(block) > 1.0F) {
                        return testToolEntry.getKey();
                    }
                }
            }
        }

//        String[] tools = new String[]{"pickaxe", "shovel", "axe", "hoe", "sword", "shears"};
//        StringBuilder s = new StringBuilder();
//
//        for (String tool : tools) {
//            TagKey<Block> toolTag = TagKey.of(BlockRegistry.KEY, Identifier.of("minecraft:mineable/" + tool));
//
//            if (state.isIn(toolTag)) {
//                s.append(StringUtils.capitalize(tool)).append(" ");
//            }
//        }
//
//        if (s.isEmpty()) {
//            return null;
//        }
//
//        harvestTool = s.toString();
        return harvestTool;
    }


    static void showHarvestLevel(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block) {
        String harvestTool = getHarvestTool(world, pos, state, block);
        String harvestLevel = getHarvestLevel(state);
        if (harvestTool != null) {
            probeInfo.text(LABEL + "Tool: " + INFO + harvestTool + " (level " + harvestLevel + ")");
        }
    }

    enum Harvestable {
        HARVESTABLE,
        NOT_HARVESTABLE,
        UNBREAKABLE
    }

    private static Harvestable isHarvestable(class_54 player, class_18 world, class_339 pos, BlockState state, class_17 block) {
        if (block.method_1595() == -1.0F) {
            return Harvestable.UNBREAKABLE;
        }

        return player.canHarvest(world, pos, state) ? Harvestable.HARVESTABLE : Harvestable.NOT_HARVESTABLE;
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        if (ProbeUtil.isHandProbe(player.method_502())) {
            // If the player holds the probe there is no need to show harvestability information as the
            // probe cannot harvest anything. This is only supposed to work in off hand.
            return;
        }

        switch (isHarvestable(player, world, pos, state, block)) {
            case HARVESTABLE -> {
                probeInfo.text(OK + "Harvestable");
            }
            case NOT_HARVESTABLE -> {
                probeInfo.text(WARNING + "Not harvestable");
            }
            case UNBREAKABLE -> {
                probeInfo.text(WARNING + "Unbreakable");
            }
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        String harvestTool = getHarvestTool(world, pos, state, block);
        String harvestLevel = getHarvestLevel(state);

        boolean v = Config.CLIENT_CONFIG.harvestStyleVanilla;
        int offs = v ? 16 : 0;
        int dim = v ? 13 : 16;

        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);

        String harvestToolString = getHarvestToolString(harvestTool, world, pos, state, block, player);

        switch (isHarvestable(player, world, pos, state, block)) {
            case HARVESTABLE -> {
                horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle)
                        .text(harvestToolString);
            }

            case NOT_HARVESTABLE -> {
                if (harvestLevel == null || harvestLevel.isEmpty()) {
                    horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle)
                            .text(harvestToolString);
                } else {
                    horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle)
                            .text(harvestToolString + WARNING + " (" + harvestLevel + " Level)");
                }
            }

            case UNBREAKABLE -> {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle)
                        .text(WARNING + "Unbreakable");
            }
        }
    }

    private static String getHarvestToolString(String harvestTool, class_18 world, class_339 pos, BlockState state, class_17 block, class_54 player) {
        if (harvestTool != null) {
            if (player.method_502() != null) {
                class_124 hand = player.method_502().method_694();
                float multiplier = player.method_502().method_694().method_438(player.method_502(), block);
                if (hand instanceof class_632 && multiplier > 1.0F) {
                    return OK + harvestTool;
                } else if (hand instanceof class_352 && multiplier <= 1.5F) {
                    return WARNING + harvestTool;
                } else if (multiplier <= 1.0F) {
                    return WARNING + harvestTool;
                }
            } else {
                return WARNING + harvestTool;
            }
        } else {
            return OK + "No Tool";
        }
        return WARNING + harvestTool;
    }
}
