package net.danygames2014.whatsthis.gui;

import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.rendering.RenderHelper;
import net.minecraft.class_32;
import net.modificationstation.stationapi.api.util.Formatting;

import static net.danygames2014.whatsthis.config.ConfigSetup.*;

public class NoteScreen extends class_32 {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 160;

    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_MARGIN = 80;
    public static final int BUTTON_HEIGHT = 16;

    private int guiLeft;
    private int guiTop;

    private static final String background = "assets/whatsthis/stationapi/textures/gui/note.png";
    private static int backgroundId = 0;

    @Override
    public boolean method_121() {
        return false;
    }

    @Override
    public void method_119() {
        super.method_119();
        guiLeft = (this.field_152 - WIDTH) / 2;
        guiTop = (this.field_153 - HEIGHT) / 2;
        backgroundId = field_151.field_2814.method_1100(background);
    }

    @Override
    public void method_118(int mouseX, int mouseY, float partialTicks) {
        super.method_118(mouseX, mouseY, partialTicks);
        field_151.field_2814.method_1097(backgroundId);
        method_1936(guiLeft, guiTop, 0, 0, WIDTH, HEIGHT);
        int x = guiLeft + 5;
        int y = guiTop + 8;
        RenderHelper.renderText(field_151, x, y, "Things you should know about" + Formatting.GOLD + " The One Probe");
        y += 10;
        y += 10;

        RenderHelper.renderText(field_151, x, y, "This mod can show a tooltip on screen");
        y += 10;
        RenderHelper.renderText(field_151, x, y, "when you look at a block or an entity");
        y += 10;

        y += 10;
        switch (Config.PROBE_CONFIG.needsProbe) {
            case PROBE_NEEDED:
                RenderHelper.renderText(field_151, x, y, "In this pack the probe is configured to be");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "required in order to see the tooltip");
                y += 10;
                y += 16;
                y = setInConfig(x, y);
                break;
            case PROBE_NOTNEEDED:
                RenderHelper.renderText(field_151, x, y, "In this pack the probe is configured to be not");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "required in order to see the tooltip");
                y += 10;
                y += 16;
                y = setInConfig(x, y);
                break;
            case PROBE_NEEDEDFOREXTENDED:
                RenderHelper.renderText(field_151, x, y, "In this pack the probe is configured to be");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "required to see extended information (when");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "sneaking) but not for basic information");
                y += 10;
                y += 6;
                y = setInConfig(x, y);
                break;
            case PROBE_NEEDEDHARD:
                RenderHelper.renderText(field_151, x, y, "In this pack the probe is configured to be");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "required in order to see the tooltip");
                y += 10;
                RenderHelper.renderText(field_151, x, y, "This is set server side");
                y += 10;
                break;
        }

        y += 10;

        RenderHelper.renderText(field_151, x, y, "Check out the 'Mod Options... for many client'");
        y += 10;
        RenderHelper.renderText(field_151, x, y, "side configuration settings or sneak-right click");
        y += 10;
        RenderHelper.renderText(field_151, x, y, "this note for more user-friendly setup");
        y += 10;
    }

    private int hitX;
    private int hitY;

    @Override
    protected void method_124(int mouseX, int mouseY, int mouseButton) {
        super.method_124(mouseX, mouseY, mouseButton);

        mouseX += guiLeft;
        mouseY += guiTop;
        if (mouseY >= hitY && mouseY < hitY + BUTTON_HEIGHT) {
            if (mouseX >= hitX && mouseX < hitX + BUTTON_WIDTH) {
                ConfigSetup.setProbeNeeded(PROBE_NEEDED);
            } else if (mouseX >= hitX + BUTTON_MARGIN && mouseX < hitX + BUTTON_WIDTH + BUTTON_MARGIN) {
                ConfigSetup.setProbeNeeded(PROBE_NOTNEEDED);
            } else if (mouseX >= hitX + BUTTON_MARGIN * 2 && mouseX < hitX + BUTTON_WIDTH + BUTTON_MARGIN * 2) {
                ConfigSetup.setProbeNeeded(PROBE_NEEDEDFOREXTENDED);
            }
        }
    }

    private int setInConfig(int x, int y) {
        RenderHelper.renderText(field_151, x, y, Formatting.GREEN + "You can change this here:");
        y += 10;

        hitY = y + guiTop;
        hitX = x + guiLeft;
        method_1932(x, y, x + BUTTON_WIDTH, y + BUTTON_HEIGHT, 0xff000000);
        RenderHelper.renderText(field_151, x + 3, y + 4, "Needed");
        x += BUTTON_MARGIN;

        method_1932(x, y, x + BUTTON_WIDTH, y + BUTTON_HEIGHT, 0xff000000);
        RenderHelper.renderText(field_151, x + 3, y + 4, "Not needed");
        x += BUTTON_MARGIN;

        method_1932(x, y, x + BUTTON_WIDTH, y + BUTTON_HEIGHT, 0xff000000);
        RenderHelper.renderText(field_151, x + 3, y + 4, "Extended");
        x += BUTTON_MARGIN;

        y += BUTTON_HEIGHT - 4;
        return y;
    }

}
