package net.danygames2014.whatsthis.item;

import java.util.ArrayList;
import net.minecraft.class_18;
import net.minecraft.class_202;
import net.minecraft.class_522;
import net.minecraft.class_58;
import net.minecraft.class_8;

public class GotNotePersistentState extends class_58 {
    public ArrayList<String> gotNote;

    public GotNotePersistentState(String id) {
        super(id);
        gotNote = new ArrayList<>();
    }

    public static GotNotePersistentState get(class_18 world, String id) {
        GotNotePersistentState gotNoteState = (GotNotePersistentState) world.field_222.method_525(GotNotePersistentState.class, id);

        if (gotNoteState == null) {
            gotNoteState = new GotNotePersistentState(id);
            world.field_222.method_527(id, gotNoteState);
        }

        return gotNoteState;
    }

    public boolean gotNote(String name) {
        return gotNote.contains(name);
    }

    public void setGotNote(String name, boolean value) {
        if (value && !gotNote.contains(name)) {
            gotNote.add(name);
        } else {
            gotNote.remove(name);
        }
    }

    @Override
    public void method_545(class_8 nbt) {
        class_202 nbtList = nbt.method_1034("gotNote");

        for (int i = 0; i < nbtList.method_1398(); i++) {
            gotNote.add(nbtList.method_1396(i).method_626());
        }
    }

    @Override
    public void method_548(class_8 nbt) {
        class_202 nbtList = new class_202();

        for (String player : gotNote) {
            nbtList.method_1397(new class_522(player));
        }

        nbt.method_1017("gotNote", nbtList);
    }
}
