package net.danygames2014.whatsthis.mixin;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.item.GotNotePersistentState;
import net.minecraft.class_127;
import net.minecraft.class_136;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_54.class)
public class PlayerEntityMixin extends class_127 {
    @Shadow
    public class_136 inventory;

    @Shadow
    public String name;

    public PlayerEntityMixin(class_18 world) {
        super(world);
    }

    @Inject(method = "<init>", at = @At(value = "TAIL"))
    public void aVoid(class_18 world, CallbackInfo ci) {
        if (world.field_180) {
            return;
        }

        if (!Config.PROBE_CONFIG.spawnNote) {
            return;
        }

        GotNotePersistentState gotNoteState = GotNotePersistentState.get(world, "got_note");

        if (!gotNoteState.gotNote(name)) {
            this.inventory.method_671(new class_31(WhatsThis.probeNote, 1));
            this.inventory.method_947();
            gotNoteState.setGotNote(name, true);
        }
    }
}
