package net.danygames2014.whatsthis.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.class_187;
import net.minecraft.class_31;
import net.minecraft.class_8;

public class NetworkUtil {

    public static class_8 readNBT(DataInputStream stream) {
        return (class_8) class_187.method_628(stream);
    }

    public static void writeNBT(DataOutputStream stream, class_8 nbt) {
        class_187.method_624(nbt, stream);
    }


    /// This function supports itemstacks with more then 64 items.
    public static class_31 readItemStack(DataInputStream stream) throws IOException {
        return new class_31(stream.readShort(), stream.readShort(), stream.readShort());
    }

    /// This function supports itemstacks with more then 64 items.
    public static void writeItemStack(DataOutputStream stream, class_31 stack) throws IOException {
        stream.writeShort(stack.field_753);
        stream.writeShort(stack.field_751);
        stream.writeShort(stack.method_722());
    }

    public static String readString(DataInputStream dataIn) throws IOException {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readFully(dst);
        return new String(dst);
    }

    public static void writeString(DataOutputStream dataOut, String str) throws IOException {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.write(bytes);
        }
    }

    public static String readStringUTF8(DataInputStream dataIn) throws IOException {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readFully(dst);
        return new String(dst, java.nio.charset.StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(DataOutputStream dataOut, String str) throws IOException {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(java.nio.charset.StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.write(bytes);
        }
    }
}
