/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeConfigProvider;
import net.danygames2014.whatsthis.api.IProbeInfoProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.ProbeHitData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.danygames2014.whatsthis.network.NetworkUtil;
import net.danygames2014.whatsthis.network.PacketReturnInfo;
import net.danygames2014.whatsthis.network.ThrowableIdentity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.NotNull;

public class PacketGetInfo
extends class_169
implements ManagedPacket<PacketGetInfo> {
    public static final PacketType<PacketGetInfo> TYPE = PacketType.builder((boolean)false, (boolean)true, PacketGetInfo::new).build();
    private int dim;
    private class_339 pos;
    private ProbeMode mode;
    private Direction sideHit;
    private class_26 hitVec;
    private class_31 pickBlock;
    private int size = 0;

    public PacketGetInfo() {
    }

    public PacketGetInfo(int dim, class_339 pos, ProbeMode mode, class_27 mouseOver, class_31 pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = Direction.byId((int)mouseOver.field_1987);
        this.hitVec = class_26.method_1293((double)mouseOver.field_1984, (double)mouseOver.field_1985, (double)mouseOver.field_1986);
        this.pickBlock = pickBlock;
    }

    public void method_806(DataInputStream stream) {
        try {
            this.dim = stream.readInt();
            this.pos = new class_339(stream.readInt(), stream.readInt(), stream.readInt());
            this.mode = ProbeMode.values()[stream.readByte()];
            byte sideByte = stream.readByte();
            this.sideHit = sideByte == 127 ? null : Direction.values()[sideByte];
            if (stream.readBoolean()) {
                this.hitVec = class_26.method_1293((double)stream.readDouble(), (double)stream.readDouble(), (double)stream.readDouble());
            }
            if (stream.readBoolean()) {
                this.pickBlock = NetworkUtil.readItemStack(stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();
            stream.writeInt(this.dim);
            stream.writeInt(this.pos.getX());
            stream.writeInt(this.pos.getY());
            stream.writeInt(this.pos.getZ());
            stream.writeByte(this.mode.ordinal());
            stream.writeByte(this.sideHit == null ? 127 : this.sideHit.ordinal());
            if (this.hitVec == null) {
                stream.writeBoolean(false);
            } else {
                stream.writeBoolean(true);
                stream.writeDouble(this.hitVec.field_1585);
                stream.writeDouble(this.hitVec.field_1586);
                stream.writeDouble(this.hitVec.field_1587);
            }
            if (this.pickBlock != null) {
                stream.writeBoolean(true);
                NetworkUtil.writeItemStack(stream, this.pickBlock);
            } else {
                stream.writeBoolean(false);
            }
            this.size = stream.size() - initialStreamSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 networkHandler) {
        switch (FabricLoader.getInstance().getEnvironmentType()) {
            case CLIENT: {
                this.handleClient(networkHandler);
                break;
            }
            case SERVER: {
                this.handleServer(networkHandler);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient(class_240 networkHandler) {
        class_18 world = Minecraft.field_2791.field_2804;
        if (world != null) {
            ProbeInfo probeInfo = PacketGetInfo.getProbeInfo((class_54)Minecraft.field_2791.field_2806, this.mode, world, this.pos, this.sideHit, this.hitVec, this.pickBlock);
            PacketHelper.sendTo((class_54)Minecraft.field_2791.field_2806, (class_169)new PacketReturnInfo(this.dim, this.pos, probeInfo));
        }
    }

    @Environment(value=EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11) {
            class_11 handler = (class_11)networkHandler;
            class_18 world = handler.field_920.field_1596;
            if (world != null) {
                ProbeInfo probeInfo = PacketGetInfo.getProbeInfo((class_54)handler.field_920, this.mode, world, this.pos, this.sideHit, this.hitVec, this.pickBlock);
                PacketHelper.sendTo((class_54)handler.field_920, (class_169)new PacketReturnInfo(this.dim, this.pos, probeInfo));
            }
        }
    }

    public int method_798() {
        return this.size;
    }

    @NotNull
    public PacketType<PacketGetInfo> getType() {
        return TYPE;
    }

    private static ProbeInfo getProbeInfo(class_54 player, ProbeMode mode, class_18 world, class_339 blockPos, Direction sideHit, class_26 hitVec, class_31 pickBlock) {
        if (Config.PROBE_CONFIG.needsProbe == 3) {
            if (!ProbeUtil.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if (Config.PROBE_CONFIG.needsProbe == 2 && !ProbeUtil.hasAProbeSomewhere(player)) {
            return null;
        }
        BlockState state = world.getBlockState(blockPos);
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = WhatsThis.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, state, data);
        }
        ConfigSetup.setProbeConfig(probeConfig);
        List<IProbeInfoProvider> providers = WhatsThis.theOneProbeImp.getProviders();
        for (IProbeInfoProvider provider : providers) {
            try {
                provider.addProbeInfo(mode, probeInfo, player, world, state, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(String.valueOf((Object)TextStyleClass.LABEL) + "Error: " + String.valueOf((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }
}

