package net.danygames2014.whatsthis.mixin;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.minecraft.class_148;
import net.minecraft.class_159;
import net.minecraft.class_31;
import net.minecraft.class_500;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_148.class)
public class CraftingRecipeManagerMixin {
    @Unique
    private boolean hasProbe = false;
    @Unique
    private class_31 helmet = null;

    @Inject(method = "craft", at = @At(value = "HEAD"), cancellable = true)
    public void probifyHelmet(class_159 c, CallbackInfoReturnable<class_31> cir) {
        for (class_31 stack : c.field_1132) {
            if (stack != null) {
                if (stack.isOf(WhatsThis.probe)) {
                    hasProbe = true;
                } else if (stack.method_694() instanceof class_500 armorItem) {
                    if (armorItem.field_2083 == 0) {
                        helmet = stack;
                    }
                }
            }
        }

        if (hasProbe && helmet != null) {
            helmet.getStationNbt().method_1021(ProbeUtil.PROBETAG, true);
            cir.setReturnValue(helmet);
        }
    }
}
