package net.danygames2014.whatsthis.mixin;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.item.GotNotePersistentState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_127;
import net.minecraft.class_136;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_54.class)
public class PlayerEntityMixin extends class_127 {
    @Shadow
    public class_136 inventory;

    @Shadow
    public String name;

    public PlayerEntityMixin(class_18 world) {
        super(world);
    }

    @Inject(method = "readNbt", at = @At(value = "TAIL"))
    public void aVoid(class_8 nbt, CallbackInfo ci) {
        if (field_1596.field_180) {
            return;
        }

        if (!Config.PROBE_CONFIG.spawnNote) {
            return;
        }

        GotNotePersistentState gotNoteState = GotNotePersistentState.get(field_1596, "got_note");

        String username = this.name;
        
        // If we are in singleplayer, the name will be null, we get the name from the session instead 
        if (username == null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            username = getClientUsername();
        }

        if (!gotNoteState.gotNote(username)) {
            this.inventory.method_671(new class_31(WhatsThis.probeNote, 1));
            this.inventory.method_947();
            gotNoteState.setGotNote(username, true);
        }
    }

    @Unique
    @Environment(EnvType.CLIENT)
    public String getClientUsername() {
        return Minecraft.field_2791.field_2809.field_872;
    }
}
