/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IProgressStyle;
import net.danygames2014.whatsthis.api.NumberFormat;
import net.danygames2014.whatsthis.apiimpl.TheOneProbeImp;
import net.danygames2014.whatsthis.apiimpl.client.ElementProgressRender;
import net.danygames2014.whatsthis.apiimpl.styles.ProgressStyle;
import net.danygames2014.whatsthis.network.NetworkUtil;

public class ElementProgress
implements IElement {
    private final long current;
    private final long max;
    private final IProgressStyle style;
    private static final DecimalFormat dfCommas = new DecimalFormat("###,###");

    public ElementProgress(long current, long max, IProgressStyle style) {
        this.current = current;
        this.max = max;
        this.style = style;
    }

    public ElementProgress(DataInputStream stream) throws IOException {
        this.current = stream.readLong();
        this.max = stream.readLong();
        this.style = new ProgressStyle().width(stream.readInt()).height(stream.readInt()).prefix(NetworkUtil.readStringUTF8(stream)).suffix(NetworkUtil.readStringUTF8(stream)).borderColor(stream.readInt()).filledColor(stream.readInt()).alternateFilledColor(stream.readInt()).backgroundColor(stream.readInt()).showText(stream.readBoolean()).numberFormat(NumberFormat.values()[stream.readByte()]).lifeBar(stream.readBoolean()).armorBar(stream.readBoolean());
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeLong(this.current);
        stream.writeLong(this.max);
        stream.writeInt(this.style.getWidth());
        stream.writeInt(this.style.getHeight());
        NetworkUtil.writeStringUTF8(stream, this.style.getPrefix());
        NetworkUtil.writeStringUTF8(stream, this.style.getSuffix());
        stream.writeInt(this.style.getBorderColor());
        stream.writeInt(this.style.getFilledColor());
        stream.writeInt(this.style.getAlternatefilledColor());
        stream.writeInt(this.style.getBackgroundColor());
        stream.writeBoolean(this.style.isShowText());
        stream.writeByte(this.style.getNumberFormat().ordinal());
        stream.writeBoolean(this.style.isLifeBar());
        stream.writeBoolean(this.style.isArmorBar());
    }

    @Override
    public void render(int x, int y) {
        ElementProgressRender.render(this.style, this.current, this.max, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        if (this.style.isLifeBar()) {
            if (this.current * 4L >= (long)this.style.getWidth()) {
                return 100;
            }
            return (int)(this.current * 4L + 2L);
        }
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_PROGRESS;
    }

    public static String format(long in, NumberFormat style, String suffix) {
        switch (style) {
            case FULL: {
                return Long.toString(in) + suffix;
            }
            case COMPACT: {
                int unit = 1000;
                if (in < (long)unit) {
                    return Long.toString(in) + " " + suffix;
                }
                int exp = (int)(Math.log(in) / Math.log(unit));
                if (suffix.startsWith("m")) {
                    suffix = suffix.substring(1);
                    if (exp - 2 >= 0) {
                        char pre = "kMGTPE".charAt(exp - 2);
                        return String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre)) + suffix;
                    }
                    return String.format("%.1f %s", (double)in / Math.pow(unit, exp), suffix);
                }
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre)) + suffix;
            }
            case COMMAS: {
                return dfCommas.format(in) + suffix;
            }
            case NONE: {
                return suffix;
            }
        }
        return Long.toString(in);
    }
}

