/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.config;

import net.danygames2014.whatsthis.api.NumberFormat;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;

public class ProbeConfig {
    @ConfigEntry(name="Probe Requirement", minValue=0.0, maxValue=3.0, comment="Is the probe needed to show the tooltip? 0 = no, 1 = yes, 2 = yes and clients cannot override, 3 = probe needed for extended info only")
    public Integer needsProbe = 3;
    @ConfigEntry(name="Probe Distance", minValue=1.0, maxValue=50.0, comment="Distance at which the probe works")
    public Float probeDistance = Float.valueOf(6.0f);
    @ConfigEntry(name="Show Debug Info", comment="If true show debug info with creative probe")
    public Boolean showDebugInfo = true;
    @ConfigEntry(name="Get Note on Spawn", comment="If true there will be a readme note for first-time players")
    public Boolean spawnNote = true;
    @ConfigEntry(name="Accessory API Support", comment="If true there will be a bauble version of the probe if baubles is present")
    public Boolean supportAccessoryApi = true;
    @ConfigEntry(name="Probe Refresh Rate", minValue=100.0, maxValue=100000.0, comment="The amount of milliseconds to wait before updating probe information from the server (this is a client-side config)")
    public Integer timeout = 300;
    @ConfigEntry(name="Server Waiting Timeout", minValue=-1.0, maxValue=100000.0, comment="The amount of milliseconds to wait before showing a 'fetch from server' info on the client (if the server is slow to respond) (-1 to disable this feature)")
    public Integer waitingForServerTimeout = 2000;
    @ConfigEntry(name="Logging Throwable Timeout", minValue=1.0, maxValue=1.0E7, comment="How much time (ms) to wait before reporting an exception again")
    public Integer loggingThrowableTimeout = 20000;
    @ConfigEntry(name="RF Display Style", minValue=0.0, maxValue=2.0, comment="How to display RF: 0 = do not show, 1 = show in a bar, 2 = show as text")
    public Integer showRF = 1;
    @ConfigEntry(name="RF Number Format", minValue=0.0, maxValue=2.0, comment="Format for displaying RF: 0 = full, 1 = compact, 2 = comma separated")
    public NumberFormat rfFormat = NumberFormat.COMPACT;
    @ConfigEntry(name="RF Bar Filled Color", comment="Color for the RF bar")
    public String rfbarFilledColor = Integer.toHexString(-2293760);
    @ConfigEntry(name="RF Bar Alternate Filled Color", comment="Alternate color for the RF bar")
    public String rfbarAlternateFilledColor = Integer.toHexString(-12386304);
    @ConfigEntry(name="RF Bar Border Color", comment="Color for the RF bar border")
    public String rfbarBorderColor = Integer.toHexString(-11184811);
    @ConfigEntry(name="Fluid Tank Display Style", minValue=0.0, maxValue=2.0, comment="How to display tank contents: 0 = do not show, 1 = show in a bar, 2 = show as text")
    public Integer showTank = 1;
    @ConfigEntry(name="Fluid Tank Number Format", minValue=0.0, maxValue=2.0, comment="Format for displaying tank contents: 0 = full, 1 = compact, 2 = comma separated")
    public NumberFormat tankFormat = NumberFormat.COMPACT;
    @ConfigEntry(name="Fluid Tank Bar Filled Color", comment="Color for the tank bar")
    public String tankbarFilledColor = Integer.toHexString(-16776995);
    @ConfigEntry(name="Fluid Tank Alternate Filled Color", comment="Alternate color for the tank bar")
    public String tankbarAlternateFilledColor = Integer.toHexString(-16777149);
    @ConfigEntry(name="Fluid Tank Bar Border Color", comment="Color for the tank bar border")
    public String tankbarBorderColor = Integer.toHexString(-11184811);
    @ConfigEntry(name="Item Detail Threshold", minValue=0.0, maxValue=20.0, comment="If the number of items in an inventory is lower or equal then this number then more info is shown")
    public Integer showItemDetailThreshold = 4;
    @ConfigEntry(name="showSmallChestContentsWithoutSneaking", minValue=0.0, maxValue=1000.0, comment="The maximum amount of slots (empty or not) to show without sneaking")
    public Integer showSmallChestContentsWithoutSneaking = 3;
    @ConfigEntry(name="showContentsWithoutSneaking", maxArrayLength=128L, comment="A list of blocks for which we automatically show chest contents even if not sneaking")
    public String[] showContentsWithoutSneaking = new String[]{"minecraft:chest"};
    @ConfigEntry(name="dontShowContentsUnlessSneaking", comment="A list of blocks for which we don't show chest contents automatically except if sneaking")
    public String[] dontShowContentsUnlessSneaking = new String[0];
    @ConfigEntry(name="dontSendNBT", comment="A list of blocks for which we don't send NBT over the network. This is mostly useful for blocks that have HUGE NBT in their pickblock (itemstack)")
    public String[] dontSendNBT = new String[0];
}

