package net.danygames2014.whatsthis.item;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.compat.AccessoryApiCompat;
import net.minecraft.class_31;
import net.minecraft.class_500;
import net.minecraft.class_54;

public class ProbeUtil {
    public static String PROBETAG = "theoneprobe";
    public static String PROBETAG_HAND = "theoneprobe_hand";

    /**
     * Determines whether the given ItemStack can be used as a probe in hand
     *
     * @param stack The ItemStack to check
     * @return Whther the ItemStack can be used as a probe in hand
     */
    public static boolean isHandProbe(class_31 stack) {
        // Check stack validity
        if (stack == null || stack.field_751 <= 0 || stack.method_694() == null) {
            return false;
        }

        // Check for default probes
        if (stack.isOf(WhatsThis.probe) || stack.isOf(WhatsThis.creativeProbe)) {
            return true;
        }

        // If there is no NBT, there wont be a tag
        if (stack.getStationNbt() == null) {
            return false;
        }

        // Return whether the ItemStack has the required tag
        return stack.getStationNbt().method_1023(PROBETAG_HAND);
    }

    /**
     * Determines whether the given ItemStack is a valid helmet with a probe
     *
     * @param stack The ItemStack to check
     * @return Whther the ItemStack is a valid helmet with a probe
     */
    private static boolean isHelmetProbe(class_31 stack) {
        // Check stack validity
        if (stack == null || stack.field_751 <= 0 || stack.method_694() == null) {
            return false;
        }

        // Check if the ItemStack is of an helmet
        if (stack.method_694() instanceof class_500 armorItem) {
            if (armorItem.field_2083 != 0) {
                return false;
            }
        }

        // If there is no NBT, there wont be a tag
        if (stack.getStationNbt() == null) {
            return false;
        }

        // Return whether the ItemStack has the required tag
        return stack.getStationNbt().method_1023(PROBETAG);
    }

    public static boolean isDebugProbe(class_31 stack) {
        // Check stack validity
        if (stack == null || stack.field_751 <= 0 || stack.method_694() == null) {
            return false;
        }

        return stack.isOf(WhatsThis.creativeProbe);

    }

    public static boolean hasAProbeSomewhere(class_54 player) {
        return hasProbeInHand(player) || hasProbeInHelmet(player) || hasProbeInBauble(player);
    }

    private static boolean hasProbeInHand(class_54 player) {
        return isHandProbe(player.method_502());
    }

    private static boolean hasProbeInHelmet(class_54 player) {
        return isHelmetProbe(player.field_519.field_746[3]);
    }

    private static boolean hasProbeInBauble(class_54 player) {
        return WhatsThis.accessoryApiCompat && AccessoryApiCompat.hasProbeGoggles(player);
    }
}
