package net.danygames2014.whatsthis.apiimpl.providers.block;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.IProbeHitData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProbeInfoProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.apiimpl.styles.LayoutStyle;
import net.danygames2014.whatsthis.config.Config;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.util.math.Direction;

import static net.danygames2014.whatsthis.api.TextStyleClass.INFO;
import static net.danygames2014.whatsthis.api.TextStyleClass.LABEL;

public class DebugProbeInfoProvider implements IProbeInfoProvider {

    @Override
    public String getID() {
        return WhatsThis.NAMESPACE.id("block_debug").toString();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, BlockState state, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && Config.PROBE_CONFIG.showDebugInfo) {
            class_17 block = state.getBlock();
            class_339 pos = data.getPos();
            showDebugInfo(probeInfo, world, state, pos, block, data.getSideHit());
        }
    }

    private void showDebugInfo(IProbeInfo probeInfo, class_18 world, BlockState blockState, class_339 pos, class_17 block, Direction side) {
        IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(0xffff4444).spacing(2))
                .text(LABEL + "Reg Name: " + INFO + BlockRegistry.INSTANCE.getId(block))
                .text(LABEL + "Unlocname: " + INFO + block.method_1597())
                .text(LABEL + "Meta: " + INFO + world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102))
                .text(LABEL + "Class: " + INFO + block.getClass().getSimpleName())
                .text(LABEL + "Hardness: " + INFO + block.getHardness(blockState, world, pos))
                .text(LABEL + "Light: " + INFO + world.method_255(pos.field_2100, pos.field_2101, pos.field_2102));

        class_55 blockEntity = world.method_1777(pos.field_2100, pos.field_2101, pos.field_2102);
        if (blockEntity != null) {
            vertical.text(LABEL + "Block Entity: " + INFO + blockEntity.getClass().getSimpleName());
        }
    }
}
