package net.danygames2014.whatsthis.mixin;

import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.danygames2014.whatsthis.keys.KeybindListener;
import net.danygames2014.whatsthis.rendering.OverlayRenderer;
import net.minecraft.class_54;
import net.minecraft.class_588;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static net.danygames2014.whatsthis.config.ConfigSetup.*;

@Mixin(class_588.class)
public class InGameHudMixin {
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lorg/lwjgl/opengl/GL11;glColor4f(FFFF)V", remap = false))
    public void renderOverlay(float tickDelta, boolean screenOpen, int mouseX, int mouseY, CallbackInfo ci) {
        if (Minecraft.field_2791.field_2824.field_1443) {
            return;
        }

        if (Config.CLIENT_CONFIG.holdKeyToMakeVisible) {
            if (!Keyboard.isKeyDown(KeybindListener.toggleVisible.field_2381)) {
                return;
            }
        } else {
            if (!Config.CLIENT_CONFIG.isVisible) {
                return;
            }
        }

        if (ProbeUtil.isDebugProbe(Minecraft.field_2791.field_2806.method_502())) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, tickDelta);
        } else {
            switch (Config.PROBE_CONFIG.needsProbe) {
                case PROBE_NOTNEEDED:
                case PROBE_NEEDEDFOREXTENDED:
                    OverlayRenderer.renderHUD(getModeForPlayer(), tickDelta);
                    break;
                case PROBE_NEEDED:
                case PROBE_NEEDEDHARD:
                    if (ProbeUtil.hasAProbeSomewhere(Minecraft.field_2791.field_2806)) {
                        OverlayRenderer.renderHUD(getModeForPlayer(), tickDelta);
                    }
                    break;
            }
        }
    }

    @Unique
    private ProbeMode getModeForPlayer() {
        class_54 player = Minecraft.field_2791.field_2806;

        // If the mode is extended by default or the player is holding a probe
        if (Config.CLIENT_CONFIG.extendedInMain || ProbeUtil.isHandProbe(player.method_502())) {
            // If the player has a probe somewhere, switch to extended mode
            if (ProbeUtil.hasAProbeSomewhere(player)) {
                return ProbeMode.EXTENDED;
            }
        }

        return player.method_1373() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }
}
