package net.danygames2014.whatsthis.network;

import net.danygames2014.whatsthis.WhatsThis;
import net.danygames2014.whatsthis.api.*;
import net.danygames2014.whatsthis.apiimpl.ProbeHitData;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.danygames2014.whatsthis.item.ProbeUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.NotNull;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

import static net.danygames2014.whatsthis.api.TextStyleClass.ERROR;
import static net.danygames2014.whatsthis.api.TextStyleClass.LABEL;
import static net.danygames2014.whatsthis.config.ConfigSetup.PROBE_NEEDEDFOREXTENDED;
import static net.danygames2014.whatsthis.config.ConfigSetup.PROBE_NEEDEDHARD;

public class PacketGetInfo extends class_169 implements ManagedPacket<PacketGetInfo> {
    public static final PacketType<PacketGetInfo> TYPE = PacketType.builder(false, true, PacketGetInfo::new).build();

    private int dim;
    private class_339 pos;
    private ProbeMode mode;
    private Direction sideHit;
    private class_26 hitVec;
    private class_31 pickBlock;

    private int size = 0;

    public PacketGetInfo() {
    }

    public PacketGetInfo(int dim, class_339 pos, ProbeMode mode, class_27 mouseOver, class_31 pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = Direction.byId(mouseOver.field_1987);
        this.hitVec = class_26.method_1293(mouseOver.field_1984, mouseOver.field_1985, mouseOver.field_1986);
        this.pickBlock = pickBlock;
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            dim = stream.readInt();
            pos = new class_339(stream.readInt(), stream.readInt(), stream.readInt());
            mode = ProbeMode.values()[stream.readByte()];
            byte sideByte = stream.readByte();
            if (sideByte == 127) {
                sideHit = null;
            } else {
                sideHit = Direction.values()[sideByte];
            }

            if (stream.readBoolean()) {
                hitVec = class_26.method_1293(stream.readDouble(), stream.readDouble(), stream.readDouble());
            }

            if (stream.readBoolean()) {
                pickBlock = NetworkUtil.readItemStack(stream);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();

            stream.writeInt(dim); // 4b
            stream.writeInt(pos.getX()); // 4b
            stream.writeInt(pos.getY()); // 4b
            stream.writeInt(pos.getZ()); // 4b
            stream.writeByte(mode.ordinal()); // 1b
            stream.writeByte(sideHit == null ? 127 : sideHit.ordinal()); // 1b
            if (hitVec == null) {
                stream.writeBoolean(false); // 1b
            } else {
                stream.writeBoolean(true); // 1b
                stream.writeDouble(hitVec.field_1585); // 8b 
                stream.writeDouble(hitVec.field_1586); // 8b
                stream.writeDouble(hitVec.field_1587); // 8b
            }

            if (pickBlock != null) {
                stream.writeBoolean(true);
                NetworkUtil.writeItemStack(stream, pickBlock);
            } else {
                stream.writeBoolean(false);
            }

            this.size = stream.size() - initialStreamSize;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_808(class_240 networkHandler) {
        switch (FabricLoader.getInstance().getEnvironmentType()) {
            case CLIENT -> {
                handleClient(networkHandler);
            }
            case SERVER -> {
                handleServer(networkHandler);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void handleClient(class_240 networkHandler) {
        class_18 world = Minecraft.field_2791.field_2804;
        if (world != null) {
            ProbeInfo probeInfo = getProbeInfo(Minecraft.field_2791.field_2806, mode, world, pos, sideHit, hitVec, pickBlock);
            PacketHelper.sendTo(Minecraft.field_2791.field_2806, new PacketReturnInfo(dim, pos, probeInfo));
        }
    }

    @Environment(EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11 handler) {
            class_18 world = handler.field_920.field_1596;
            if (world != null) {
                ProbeInfo probeInfo = getProbeInfo(handler.field_920, mode, world, pos, sideHit, hitVec, pickBlock);
                PacketHelper.sendTo(handler.field_920, new PacketReturnInfo(dim, pos, probeInfo));
            }
        }
    }

    @Override
    public int method_798() {
        return this.size;
    }

    @Override
    public @NotNull PacketType<PacketGetInfo> getType() {
        return TYPE;
    }

    private static ProbeInfo getProbeInfo(class_54 player, ProbeMode mode, class_18 world, class_339 blockPos, Direction sideHit, class_26 hitVec, class_31 pickBlock) {
        if (Config.PROBE_CONFIG.needsProbe == PROBE_NEEDEDFOREXTENDED) {
            // We need a probe only for extended information
            if (!ProbeUtil.hasAProbeSomewhere(player)) {
                // No probe anywhere, switch EXTENDED to NORMAL
                if (mode == ProbeMode.EXTENDED) {
                    mode = ProbeMode.NORMAL;
                }
            }
        } else if (Config.PROBE_CONFIG.needsProbe == PROBE_NEEDEDHARD && !ProbeUtil.hasAProbeSomewhere(player)) {
            // The server says we need a probe but we don't have one in our hands
            return null;
        }

        BlockState state = world.getBlockState(blockPos);
        ProbeInfo probeInfo = WhatsThis.theOneProbeImp.create();
        IProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);

        IProbeConfig probeConfig = WhatsThis.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = WhatsThis.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, state, data);
        }
        ConfigSetup.setProbeConfig(probeConfig);

        List<IProbeInfoProvider> providers = WhatsThis.theOneProbeImp.getProviders();
        for (IProbeInfoProvider provider : providers) {
            try {
                provider.addProbeInfo(mode, probeInfo, player, world, state, data);
            } catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(LABEL + "Error: " + ERROR + provider.getID());
            }
        }
        return probeInfo;
    }

}
