package net.danygames2014.whatsthis.network;

import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.rendering.OverlayRenderer;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_339;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import org.jetbrains.annotations.NotNull;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketReturnInfo extends class_169 implements ManagedPacket<PacketReturnInfo> {
    public static final PacketType<PacketReturnInfo> TYPE = PacketType.builder(true, false, PacketReturnInfo::new).build();

    private int dim;
    private class_339 pos;
    private ProbeInfo probeInfo;

    private int size;

    public PacketReturnInfo() {
    }

    public PacketReturnInfo(int dim, class_339 pos, ProbeInfo probeInfo) {
        this.dim = dim;
        this.pos = pos;
        this.probeInfo = probeInfo;
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            dim = stream.readInt();
            pos = new class_339(stream.readInt(), stream.readInt(), stream.readInt());
            if (stream.readBoolean()) {
                probeInfo = new ProbeInfo(stream);
            } else {
                probeInfo = null;
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            int streamInitialSize = stream.size();

            stream.writeInt(dim);
            stream.writeInt(pos.getX());
            stream.writeInt(pos.getY());
            stream.writeInt(pos.getZ());

            if (probeInfo != null) {
                stream.writeBoolean(true);
                probeInfo.toBytes(stream);
            } else {
                stream.writeBoolean(false);
            }

            this.size = stream.size() - streamInitialSize;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    @Override
    public void method_808(class_240 networkHandler) {
        OverlayRenderer.registerProbeInfo(dim, pos, probeInfo);
    }

    @Override
    public int method_798() {
        return this.size;
    }

    @Override
    public @NotNull PacketType<PacketReturnInfo> getType() {
        return TYPE;
    }
}
