/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.whatsthis.apiimpl.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IEntityStyle;
import net.danygames2014.whatsthis.api.IIconStyle;
import net.danygames2014.whatsthis.api.IItemStyle;
import net.danygames2014.whatsthis.api.ILayoutStyle;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProgressStyle;
import net.danygames2014.whatsthis.api.ITextStyle;
import net.danygames2014.whatsthis.apiimpl.ProbeInfo;
import net.danygames2014.whatsthis.apiimpl.elements.ElementEntity;
import net.danygames2014.whatsthis.apiimpl.elements.ElementHorizontal;
import net.danygames2014.whatsthis.apiimpl.elements.ElementIcon;
import net.danygames2014.whatsthis.apiimpl.elements.ElementItemLabel;
import net.danygames2014.whatsthis.apiimpl.elements.ElementItemStack;
import net.danygames2014.whatsthis.apiimpl.elements.ElementProgress;
import net.danygames2014.whatsthis.apiimpl.elements.ElementText;
import net.danygames2014.whatsthis.apiimpl.elements.ElementVertical;
import net.danygames2014.whatsthis.apiimpl.styles.EntityStyle;
import net.danygames2014.whatsthis.apiimpl.styles.IconStyle;
import net.danygames2014.whatsthis.apiimpl.styles.ItemStyle;
import net.danygames2014.whatsthis.apiimpl.styles.LayoutStyle;
import net.danygames2014.whatsthis.apiimpl.styles.ProgressStyle;
import net.danygames2014.whatsthis.apiimpl.styles.TextStyle;
import net.danygames2014.whatsthis.rendering.RenderHelper;
import net.minecraft.class_31;
import net.minecraft.class_57;

public abstract class AbstractElementPanel
implements IElement,
IProbeInfo {
    protected List<IElement> children = new ArrayList<IElement>();
    protected Integer borderColor;
    protected int spacing;
    protected ElementAlignment alignment;

    public AbstractElementPanel(Integer borderColor, int spacing, ElementAlignment alignment) {
        this.borderColor = borderColor;
        this.spacing = spacing;
        this.alignment = alignment;
    }

    public AbstractElementPanel(DataInputStream stream) {
        try {
            this.children = ProbeInfo.createElements(stream);
            if (stream.readBoolean()) {
                this.borderColor = stream.readInt();
            }
            this.spacing = stream.readShort();
            this.alignment = ElementAlignment.values()[stream.readShort()];
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public void toBytes(DataOutputStream stream) {
        try {
            ProbeInfo.writeElements(this.children, stream);
            if (this.borderColor != null) {
                stream.writeBoolean(true);
                stream.writeInt(this.borderColor);
            } else {
                stream.writeBoolean(false);
            }
            stream.writeShort((short)this.spacing);
            stream.writeShort((short)this.alignment.ordinal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void render(int x, int y) {
        if (this.borderColor != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            RenderHelper.drawHorizontalLine(x, y, x + w - 1, this.borderColor);
            RenderHelper.drawHorizontalLine(x, y + h - 1, x + w - 1, this.borderColor);
            RenderHelper.drawVerticalLine(x, y, y + h - 1, this.borderColor);
            RenderHelper.drawVerticalLine(x + w - 1, y, y + h, this.borderColor);
        }
    }

    @Override
    public IProbeInfo icon(String icon, int u, int v, int w, int h) {
        return this.icon(icon, u, v, w, h, new IconStyle());
    }

    @Override
    public IProbeInfo icon(String icon, int u, int v, int w, int h, IIconStyle style) {
        this.children.add(new ElementIcon(icon, u, v, w, h, style));
        return this;
    }

    @Override
    public IProbeInfo text(String text) {
        this.children.add(new ElementText(text));
        return this;
    }

    @Override
    public IProbeInfo text(String text, ITextStyle style) {
        this.children.add(new ElementText(text));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(class_31 stack, ITextStyle style) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(class_31 stack) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName, IEntityStyle style) {
        this.children.add(new ElementEntity(entityName, style));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName) {
        return this.entity(entityName, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo entity(class_57 entity, IEntityStyle style) {
        this.children.add(new ElementEntity(entity, style));
        return this;
    }

    @Override
    public IProbeInfo entity(class_57 entity) {
        return this.entity(entity, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo item(class_31 stack, IItemStyle style) {
        this.children.add(new ElementItemStack(stack, style));
        return this;
    }

    @Override
    public IProbeInfo item(class_31 stack) {
        return this.item(stack, new ItemStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo progress(long current, long max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(long current, long max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo horizontal(ILayoutStyle style) {
        ElementHorizontal e = new ElementHorizontal(style.getBorderColor(), style.getSpacing(), style.getAlignment());
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo horizontal() {
        ElementHorizontal e = new ElementHorizontal(null, this.spacing, ElementAlignment.ALIGN_TOPLEFT);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical(ILayoutStyle style) {
        ElementVertical e = new ElementVertical(style.getBorderColor(), style.getSpacing(), style.getAlignment());
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical() {
        ElementVertical e = new ElementVertical(null, 2, ElementAlignment.ALIGN_TOPLEFT);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo element(IElement element) {
        this.children.add(element);
        return this;
    }

    @Override
    public ILayoutStyle defaultLayoutStyle() {
        return new LayoutStyle();
    }

    @Override
    public IProgressStyle defaultProgressStyle() {
        return new ProgressStyle();
    }

    @Override
    public ITextStyle defaultTextStyle() {
        return new TextStyle();
    }

    @Override
    public IItemStyle defaultItemStyle() {
        return new ItemStyle();
    }

    @Override
    public IEntityStyle defaultEntityStyle() {
        return new EntityStyle();
    }

    @Override
    public IIconStyle defaultIconStyle() {
        return new IconStyle();
    }
}

