package net.danygames2014.gambac;

import net.minecraft.class_447;
import net.minecraft.class_564;
import net.minecraft.class_622;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BrnoMinecraft extends Minecraft {

    private final Frame frame;
    private int previousWidth, previousHeight;

    public BrnoMinecraft(int width, int height, boolean fullscreen) {
        super(null, null, null, width, height, fullscreen);
        this.previousWidth = width;
        this.previousHeight = height;
        this.frame = new Frame("Minecraft");
    }

    @Override
    public void method_2102(class_447 throwable) { // displayUnexpectedThrowable(UnexpectedThrowable)
        this.frame.removeAll();
        this.frame.add(new class_622(throwable), "Center");
        this.frame.validate();
        this.frame.setSize(this.field_2802, this.field_2803);
        this.frame.setLocationRelativeTo(null);
        this.frame.setAutoRequestFocus(true);
        this.frame.addWindowListener(new WindowAdapter() {
                                         public void windowClosing(WindowEvent we) {
                                             frame.dispose();
                                             System.exit(1);
                                         }
                                     }
        );
        this.frame.setVisible(true);
        Display.destroy();
    }

    @Override
    public void method_2106() {
        Display.setResizable(true);
        super.method_2106();
        Display.setTitle("Minecraft Beta 1.7.3");

        ByteBuffer[] icons = new ByteBuffer[2];
        try {
            icons[0] = loadIcon("/assets/gambac/icons/16.png");
            icons[1] = loadIcon("/assets/gambac/icons/32.png");
        } catch (Exception ignored) {
        }

        if(icons[0] != null && icons[1] != null){
            Display.setIcon(icons);
        }

        try {
            Display.makeCurrent();
            Display.update();
        } catch (LWJGLException e) {
            System.err.println("Error while making the Display current");
            //noinspection CallToPrintStackTrace
            e.printStackTrace();
        }
    }


    @Override
    public void method_2137() {
        if (GL11.glGetString(GL11.GL_RENDERER).contains("Apple M")) {
            GL11.glEnable(GL30.GL_FRAMEBUFFER_SRGB);
        }

        if (Display.getWidth() != this.field_2802 || Display.getHeight() != this.field_2803) {
            this.method_2108(Display.getWidth(), Display.getHeight());
        }

        super.method_2137();
    }

    private static ByteBuffer loadIcon(String path) {
        try {
            InputStream stream = BrnoMinecraft.class.getResourceAsStream(path);
            if (stream == null) {
                throw new RuntimeException("Icon resource not found: " + path);
            }
            BufferedImage image = ImageIO.read(stream);

            int[] pixels = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());

            ByteBuffer buffer = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);

            for (int y = 0; y < image.getHeight(); y++) {
                for (int x = 0; x < image.getWidth(); x++) {
                    int pixel = pixels[y * image.getWidth() + x];
                    buffer.put((byte) ((pixel >> 16) & 0xFF)); // Red
                    buffer.put((byte) ((pixel >> 8) & 0xFF));  // Green
                    buffer.put((byte) (pixel & 0xFF));         // Blue
                    buffer.put((byte) ((pixel >> 24) & 0xFF)); // Alpha
                }
            }

            buffer.flip();
            return buffer;
        } catch (Exception e) {
            return null;
        }
    }


    @Override
    public void method_2136() {
        final Object fullscreen_b;
        boolean fullscreen;

        try {
            fullscreen_b = this.getClass().getDeclaredField("fullscreen").get(this);
            fullscreen = (boolean) fullscreen_b;
        } catch (NoSuchFieldException | IllegalAccessException ignore) {
            fullscreen = Display.isFullscreen();
        }

        try {
            fullscreen = !fullscreen;
            if (fullscreen) {
                this.previousWidth = Display.getWidth();
                this.previousHeight = Display.getHeight();

                Display.setDisplayMode(Display.getDesktopDisplayMode());
                this.field_2802 = Display.getDisplayMode().getWidth();
                this.field_2803 = Display.getDisplayMode().getHeight();
            } else {
                this.field_2802 = this.previousWidth;
                this.field_2803 = this.previousHeight;
                Display.setDisplayMode(new DisplayMode(this.field_2802, this.field_2803));
            }
            if (this.field_2802 <= 0) {
                this.field_2802 = 1;
            }
            if (this.field_2803 <= 0) {
                this.field_2803 = 1;
            }

            if (this.field_2816 != null) {
                this.method_2108(this.field_2802, this.field_2803);
            }

            Display.setFullscreen(fullscreen);
            Display.update();
        } catch (Exception e) {
            //noinspection CallToPrintStackTrace
            e.printStackTrace();
        }

        try {
            this.getClass().getDeclaredField("fullscreen").set(this, fullscreen);
        } catch (NoSuchFieldException | IllegalAccessException ignore) {

        }
    }

    private void method_2108(int width, int height) { // resize
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.field_2802 = width;
        this.field_2803 = height;
        if (this.field_2816 != null) {
            class_564 scaler = new class_564(this.field_2824, width, height);
            int scaledWidth = scaler.method_1857();
            int scaledHeight = scaler.method_1858();
            this.field_2816.method_125(this, scaledWidth, scaledHeight);
        }
    }
}
