package net.danygames2014.modmenu.gui;

import com.google.common.base.Joiner;
import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.config.ModMenuConfigManager;
import net.danygames2014.modmenu.gui.widget.Controller;
import net.danygames2014.modmenu.gui.widget.DescriptionListWidgetModMenu;
import net.danygames2014.modmenu.gui.widget.ModListWidgetModMenu;
import net.danygames2014.modmenu.gui.widget.TextFieldAccess;
import net.danygames2014.modmenu.gui.widget.TexturedButtonWidget;
import net.danygames2014.modmenu.gui.widget.entries.ModListEntry;
import net.danygames2014.modmenu.util.DrawingUtil;
import net.danygames2014.modmenu.util.ScreenUtil;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.danygames2014.modmenu.util.mod.ModBadgeRenderer;
import net.minecraft.class_181;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_583;
import net.minecraft.class_92;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.nio.file.Path;
import java.util.*;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

@SuppressWarnings("unchecked")
public class ModsScreen extends class_32 implements Controller {
	private static final String FILTERS_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/filters_button.png";
	private static final String CONFIGURE_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/configure_button.png";

	private static final int SEARCH_BOX = 0;
	private static final int DESCRIPTION_LIST = 1;
	private static final int WEBSITE = 2;
	private static final int ISSUES = 3;
	private static final int FILTERS = 4;
	private static final int SORTING = 5;
	private static final int LIBRARIES = 6;
	private static final int MODS_FOLDER = 7;
	private static final int DONE = 8;
	public static final int MODS_LIST_CONFIRM_ID_OFFSET = 10;
	private static final String TOGGLE_FILTER_OPTIONS = class_300.method_992().method_993("modmenu.toggleFilterOptions");
	private static final String CONFIGURE = class_300.method_992().method_993("modmenu.configure");
	private static final Logger LOGGER = LogManager.getLogger("Mod Menu | ModsScreen");
	private static final class_92 itemRenderer = new class_92();
	private class_181 searchBox;
	private DescriptionListWidgetModMenu descriptionListWidget;
	private final String title;
	private final class_32 previousScreen;
	private ModListWidgetModMenu modList;
	private ModListEntry selected;
	private ModBadgeRenderer modBadgeRenderer;
	private float scrollPercent = 0;
	private boolean init = false;
	private boolean filterOptionsShown = false;
	private int paneY;
	private static final int RIGHT_PANE_Y = 48;
	private int paneWidth;
	private int rightPaneX;
	private int searchBoxX;
	private int filtersX;
	private int filtersWidth;
	private int searchRowWidth;
	public final Set<String> showModChildren = new HashSet<>();
	private int mouseX;
	private int mouseY;
	private List<String> tooltip;

	public final Map<String, Boolean> modHasConfigScreen = new HashMap<>();
	public final Map<String, Throwable> modScreenErrors = new HashMap<>();

	public ModsScreen(class_32 previousScreen) {
		this.title = class_300.method_992().method_993("modmenu.title");
		this.previousScreen = previousScreen;
	}

	@Override
	public void setValue(String value) {
		modList.filter(value, false);
	}

	@Override
	public void method_131() {
		super.method_131();
		if (modList.isMouseInList(mouseX, mouseY)) {
//			this.modList.handleMouse();
		} else if (descriptionListWidget.isMouseInList(mouseX, mouseY)) {
			this.descriptionListWidget.handleMouse();
		}
	}

	@Override
	public void method_122() {
		this.searchBox.method_1882();
	}

	@Override
	public void method_119() {
		paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 48 + 19;
		paneWidth = this.field_152 / 2 - 8;
		rightPaneX = field_152 - paneWidth;

		int filtersButtonSize = (ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22);
		int searchWidthMax = paneWidth - 32 - filtersButtonSize;
		int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
		searchBoxX = paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
		this.searchBox = new class_181(this, this.field_156, searchBoxX, 22, searchBoxWidth, 20, "");
		((TextFieldAccess) this.searchBox).setController(this);

		for (Mod mod : ModMenu.MODS.values()) {
			String id = mod.getId();
			if (!modHasConfigScreen.containsKey(id)) {
				try {
					class_32 configScreen = ModMenu.getConfigScreen(id, this);
					modHasConfigScreen.put(id, configScreen != null);
				} catch (java.lang.NoClassDefFoundError e) {
					LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
					modScreenErrors.put(id, e);
					modHasConfigScreen.put(id, false);
				} catch (Throwable e) {
					LOGGER.error("Error from mod '" + id + "'", e);
					modScreenErrors.put(id, e);
					modHasConfigScreen.put(id, false);
				}
			}
		}

		this.modList = new ModListWidgetModMenu(this.field_151, paneWidth, this.field_153, paneY, this.field_153 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.method_1876(), this.modList, this);
		this.modList.setX(0);
		modList.reloadFilters();

		this.descriptionListWidget = new DescriptionListWidgetModMenu(this.field_151, paneWidth, this.field_153, RIGHT_PANE_Y + 60, this.field_153 - 36, DrawingUtil.fontHeight + 1, this);
		this.descriptionListWidget.setX(rightPaneX);
		class_33 configureButton = new TexturedButtonWidget(DESCRIPTION_LIST, field_152 - 24, RIGHT_PANE_Y, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64) {
			private String tooltip;
			@Override
			public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
				String modId = "";						
				if (selected != null) {
					modId = selected.getMod().getId();
				}
				
				if (selected != null) {
					field_1374 = modHasConfigScreen.get(modId);
				} else {
					field_1374 = false;
					field_1375 = false;
				}
				field_1375 = selected != null && modHasConfigScreen.get(modId) || modScreenErrors.containsKey(modId);
				if (modScreenErrors.containsKey(modId)) {
					Throwable e = modScreenErrors.get(modId);
					this.tooltip = class_300.method_992().method_994("modmenu.configure.error", modId, modId) + "\n\n" /*+ Formatting.RED*/ + e.toString();
				} else {
					this.tooltip = CONFIGURE;
				}
				super.method_1186(minecraft, mouseX, mouseY);
			}
		};
		int urlButtonWidths = paneWidth / 2 - 2;
		int cappedButtonWidth = Math.min(urlButtonWidths, 200);
		class_33 websiteButton = new class_33(WEBSITE, rightPaneX + (urlButtonWidths / 2) - (cappedButtonWidth / 2), RIGHT_PANE_Y + 36, Math.min(urlButtonWidths, 200), 20, class_300.method_992().method_993("modmenu.website")) {
			@Override
			public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
				field_1375 = selected != null;
				field_1374 = field_1375 && selected.getMod().getWebsite() != null;
				super.method_1186(minecraft, mouseX, mouseY);
			}
		};
		class_33 issuesButton = new class_33(ISSUES, rightPaneX + urlButtonWidths + 4 + (urlButtonWidths / 2) - (cappedButtonWidth / 2), RIGHT_PANE_Y + 36, Math.min(urlButtonWidths, 200), 20, class_300.method_992().method_993("modmenu.issues")) {
			@Override
			public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
				field_1375 = selected != null;
				field_1374 = field_1375 && selected.getMod().getIssueTracker() != null;
				super.method_1186(minecraft, mouseX, mouseY);
			}
		};
		class_33 filtersButton = new TexturedButtonWidget(FILTERS, paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64);
		if (!ModMenuConfig.CONFIG_MODE.getValue()) {
			this.field_154.add(filtersButton);
		}
		String showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
		String sortingText = ModMenuConfig.SORTING.getValueLabel();
		int showLibrariesWidth = field_156.method_1901(showLibrariesText) + 20;
		int sortingWidth = field_156.method_1901(sortingText) + 20;
		filtersWidth = showLibrariesWidth + sortingWidth + 2;
		searchRowWidth = searchBoxX + searchBoxWidth + 22;
		updateFiltersX();
		this.field_154.add(new class_33(SORTING, filtersX, 45, sortingWidth, 20, sortingText) {
			@Override
			public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
				field_1375 = filterOptionsShown;
				this.field_1372 = ModMenuConfig.SORTING.getValueLabel();
				super.method_1186(minecraft, mouseX, mouseY);
			}
		});
		this.field_154.add(new class_33(LIBRARIES, filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText) {
			@Override
			public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
				field_1375 = filterOptionsShown;
				this.field_1372 = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
				super.method_1186(minecraft, mouseX, mouseY);
			}
		});
		if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
			this.field_154.add(configureButton);
		}
		this.field_154.add(websiteButton);
		this.field_154.add(issuesButton);
		this.field_154.add(new class_33(MODS_FOLDER, this.field_152 / 2 - 154, this.field_153 - 28, 150, 20, class_300.method_992().method_993("modmenu.modsFolder")));
		this.field_154.add(new class_33(DONE, this.field_152 / 2 + 4, this.field_153 - 28, 150, 20, class_300.method_992().method_993("gui.done")));
		this.searchBox.method_1881(true);

		init = true;
	}

	@Override
	public void method_120(class_33 button) {
		switch (button.field_1373) {
		case DESCRIPTION_LIST: {
			final String id = Objects.requireNonNull(selected).getMod().getId();
			if (modHasConfigScreen.get(id)) {
				class_32 configScreen = ModMenu.getConfigScreen(id, this);
				field_151.method_2112(configScreen);
			} else {
				button.field_1374 = false;
			}
			break;
		}
		case WEBSITE: {
			final Mod mod = Objects.requireNonNull(selected).getMod();
			field_151.method_2112(new ConfirmChatLinkScreen(this, mod.getWebsite(), WEBSITE) {

				@Override
				public void copy() {
				}
			});
			break;
		}
		case ISSUES: {
			final Mod mod = Objects.requireNonNull(selected).getMod();
			field_151.method_2112(new ConfirmChatLinkScreen(this, mod.getIssueTracker(), ISSUES) {

				@Override
				public void copy() {
				}
			});
			break;
		}
		case FILTERS: {
			filterOptionsShown = !filterOptionsShown;
			break;
		}
		case SORTING: {
			ModMenuConfig.SORTING.cycleValue();
			ModMenuConfigManager.save();
			modList.reloadFilters();
			break;
		}
		case LIBRARIES: {
			ModMenuConfig.SHOW_LIBRARIES.toggleValue();
			ModMenuConfigManager.save();
			modList.reloadFilters();
			break;
		}
		case MODS_FOLDER: {
			//TODO: FUCk
			//OsUtil.openFolder(new File(FabricLoader.getInstance().getGameDir().toFile(), "mods"));
			break;
		}
		case DONE: {
			field_151.method_2112(previousScreen);
			break;
		}
		}
	}

	@Override
	public void method_117(char chr, int key) {
		this.searchBox.method_1877(chr, key);
		// Prevent mod list scrolling down when pressing alt
		// Handling keyboard input is done by the TextFieldWidget Mixin
		// this.modList.reloadFilters();
		super.method_117(chr, key);
	}

	@Override
	public void method_124(int mouseX, int mouseY, int button) {
		if (this.modList.isMouseInList(mouseX, mouseY)) {
			this.modList.mouseClicked(mouseX, mouseY, button);
		}
		if (this.descriptionListWidget.isMouseInList(mouseX, mouseY)) {
			this.descriptionListWidget.mouseClicked(mouseX, mouseY, button);
		}
		super.method_124(mouseX, mouseY, button);
	}

	@Override
	public void method_118(int mouseX, int mouseY, float delta) {
		this.mouseX = mouseX;
		this.mouseY = mouseY;
		this.tooltip = null;
		this.method_127(0);
		ModListEntry selectedEntry = selected;
		if (selectedEntry != null) {
			this.descriptionListWidget.method_1256(mouseX, mouseY, delta);
		}
		this.modList.method_1256(mouseX, mouseY, delta);
		this.searchBox.method_1883();
		GL11.glDisable(GL11.GL_BLEND);
		this.method_1934(this.field_156, this.title, this.modList.getWidth() / 2, 8, 16777215);
		if (!ModMenuConfig.CONFIG_MODE.getValue()) {
			String fullModCount = computeModCountText(true);
			if (!ModMenuConfig.CONFIG_MODE.getValue() && updateFiltersX()) {
				if (filterOptionsShown) {
					if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || field_156.method_1901(fullModCount) <= filtersX - 5) {
						this.field_156.method_1906(fullModCount, searchBoxX, 52, 0xFFFFFF);
					} else {
						this.field_156.method_1906(computeModCountText(false), searchBoxX, 46, 0xFFFFFF);
						this.field_156.method_1906(computeLibraryCountText(), searchBoxX, 57, 0xFFFFFF);
					}
				} else {
					if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || field_156.method_1901(fullModCount) <= modList.getWidth() - 5) {
						this.field_156.method_1906(fullModCount, searchBoxX, 52, 0xFFFFFF);
					} else {
						this.field_156.method_1906(computeModCountText(false), searchBoxX, 46, 0xFFFFFF);
						this.field_156.method_1906(computeLibraryCountText(), searchBoxX, 57, 0xFFFFFF);
					}
				}
			}
		}
		if (selectedEntry != null) {
			Mod mod = selectedEntry.getMod();
			int x = rightPaneX;
			if ("java".equals(mod.getId())) {
				DrawingUtil.drawRandomVersionBackground(mod, x, RIGHT_PANE_Y, 32, 32);
			}
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			GL11.glEnable(GL11.GL_BLEND);
			this.selected.bindIconTexture();
			DrawingUtil.drawTexture(x, RIGHT_PANE_Y, 0.0F, 0.0F, 32, 32, 32, 32);
			GL11.glDisable(GL11.GL_BLEND);
			int lineSpacing = DrawingUtil.fontHeight + 1;
			int imageOffset = 36;
			String name = mod.getTranslatedName();
			String trimmedName = name;
			int maxNameWidth = this.field_152 - (x + imageOffset);
			if (field_156.method_1901(name) > maxNameWidth) {
				String ellipsis = "...";
				trimmedName = field_156.trim(name, maxNameWidth - field_156.method_1901(ellipsis)) + ellipsis;
			}
			this.field_156.method_1906(trimmedName, x + imageOffset, RIGHT_PANE_Y + 1, 0xFFFFFF);
			if (mouseX > x + imageOffset && mouseY > RIGHT_PANE_Y + 1 && mouseY < RIGHT_PANE_Y + 1 + DrawingUtil.fontHeight && mouseX < x + imageOffset + field_156.method_1901(trimmedName)) {
				setTooltip(Collections.singletonList(class_300.method_992().method_994("modmenu.modIdToolTip", mod.getId())));
			}
			if (init || modBadgeRenderer == null || modBadgeRenderer.getMod() != mod) {
				modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_151.field_2815.method_1901(trimmedName) + 2, RIGHT_PANE_Y, field_152 - 28, selectedEntry.mod, this);
				init = false;
			}
			if (!ModMenuConfig.HIDE_BADGES.getValue()) {
				modBadgeRenderer.draw(mouseX, mouseY);
			}
			if (mod.isReal()) {
				this.field_156.method_1906(mod.getPrefixedVersion(), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing, 0x808080);
			}
			String authors;
			List<String> names = mod.getAuthors();

			if (!names.isEmpty()) {
				if (names.size() > 1) {
					authors = Joiner.on(", ").join(names);
				} else {
					authors = names.get(0);
				}
				DrawingUtil.drawWrappedString(class_300.method_992().method_994("modmenu.authorPrefix", authors), x + imageOffset, RIGHT_PANE_Y + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0x808080);
			}
		}
		super.method_118(mouseX, mouseY, delta);
		if (this.tooltip != null && !this.tooltip.isEmpty()) {
			this.renderTooltip(this.tooltip, mouseX, mouseY);
		}
	}

	private String computeModCountText(boolean includeLibs) {
		int[] rootMods = formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains(Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));

		if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
			int[] rootLibs = formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
			return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
		} else {
			return TranslationUtil.translateNumeric("modmenu.showingMods", rootMods);
		}
	}

	private String computeLibraryCountText() {
		if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
			int[] rootLibs = formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
			return TranslationUtil.translateNumeric("modmenu.showingLibraries", rootLibs);
		} else {
			return "";
		}
	}

	private int[] formatModCount(Set<String> set) {
		int visible = modList.getDisplayedCountFor(set);
		int total = set.size();
		if (visible == total) {
			return new int[]{total};
		}
		return new int[]{visible, total};
	}

	public void setTooltip(List<String> tooltip) {
		this.tooltip = tooltip;
	}

	public ModListEntry getSelectedEntry() {
		return selected;
	}

	public void updateSelectedEntry(ModListEntry entry) {
		if (entry != null) {
			this.selected = entry;
		}
	}

	public float getScrollPercent() {
		return scrollPercent;
	}

	public void updateScrollPercent(float scrollPercent) {
		this.scrollPercent = scrollPercent;
	}

	public String getSearchInput() {
		return searchBox.method_1876();
	}

	private boolean updateFiltersX() {
		if ((filtersWidth + field_156.method_1901(computeModCountText(true)) + 20) >= searchRowWidth && ((filtersWidth + field_156.method_1901(computeModCountText(false)) + 20) >= searchRowWidth || (filtersWidth + field_156.method_1901(computeLibraryCountText()) + 20) >= searchRowWidth)) {
			filtersX = paneWidth / 2 - filtersWidth / 2;
			return !filterOptionsShown;
		} else {
			filtersX = searchRowWidth - filtersWidth + 1;
			return true;
		}
	}

	private static boolean isFabricMod(Path mod) {
		try (JarFile jarFile = new JarFile(mod.toFile())) {
			return jarFile.getEntry("fabric.mod.json") != null;
		} catch (IOException e) {
			return false;
		}
	}

	public Map<String, Boolean> getModHasConfigScreen() {
		return modHasConfigScreen;
	}

	@Override
	public void method_126(boolean result, int id) {
		if (id < MODS_LIST_CONFIRM_ID_OFFSET) {
			super.method_126(result, id);
			if (result && this.selected != null) {
				switch (id) {
				case WEBSITE:
					ScreenUtil.openLink(this, this.selected.mod.getWebsite(), this.selected.mod.getId() + " /website");
					break;
				case ISSUES:
					ScreenUtil.openLink(this, this.selected.mod.getIssueTracker(), this.selected.mod.getId() + "/issues");
					break;
				}
			}

			this.field_151.method_2112(this);
		} else {
			this.descriptionListWidget.confirmResult(result, id);
		}
	}

	protected void renderTooltip(String text, int x, int y) {
		this.renderTooltip(Collections.singletonList(text), x, y);
	}

	protected void renderTooltip(List<String> text, int x, int y) {
		int n;
		if (text.isEmpty()) {
			return;
		}
		GL11.glDisable(32826);
		class_583.method_1927();
		GL11.glDisable(2896);
		GL11.glDisable(2929);
		int n2 = 0;
		for (String string : text) {
			n = this.field_156.method_1901(string);
			if (n <= n2)
				continue;
			n2 = n;
		}
		int n3 = x + 12;
		int n4 = y - 12;
		n = n2;
		int n5 = 8;
		if (text.size() > 1) {
			n5 += 2 + (text.size() - 1) * 10;
		}
		if (n3 + n2 > this.field_152) {
			n3 -= 28 + n2;
		}
		if (n4 + n5 + 6 > this.field_153) {
			n4 = this.field_153 - n5 - 6;
		}
		this.field_2522 = 300.0f;
		GL11.glPushMatrix();
		GL11.glTranslatef(0.0F, 0.0F, 300.0F);
		int n6 = -267386864;
		this.method_1933(n3 - 3, n4 - 4, n3 + n + 3, n4 - 3, n6, n6);
		this.method_1933(n3 - 3, n4 + n5 + 3, n3 + n + 3, n4 + n5 + 4, n6, n6);
		this.method_1933(n3 - 3, n4 - 3, n3 + n + 3, n4 + n5 + 3, n6, n6);
		this.method_1933(n3 - 4, n4 - 3, n3 - 3, n4 + n5 + 3, n6, n6);
		this.method_1933(n3 + n + 3, n4 - 3, n3 + n + 4, n4 + n5 + 3, n6, n6);
		int n7 = 0x505000FF;
		int n8 = (n7 & 0xFEFEFE) >> 1 | n7 & 0xFF000000;
		this.method_1933(n3 - 3, n4 - 3 + 1, n3 - 3 + 1, n4 + n5 + 3 - 1, n7, n8);
		this.method_1933(n3 + n + 2, n4 - 3 + 1, n3 + n + 3, n4 + n5 + 3 - 1, n7, n8);
		this.method_1933(n3 - 3, n4 - 3, n3 + n + 3, n4 - 3 + 1, n7, n7);
		this.method_1933(n3 - 3, n4 + n5 + 2, n3 + n + 3, n4 + n5 + 3, n8, n8);
		for (int i = 0; i < text.size(); ++i) {
			String string = text.get(i);
			this.field_156.method_1903(string, n3, n4, -1);
			if (i == 0) {
				n4 += 2;
			}
			n4 += 10;
		}
		this.field_2522 = 0.0f;
		GL11.glPopMatrix();
		GL11.glEnable(2896);
		GL11.glEnable(2929);
		class_583.method_1930();
		GL11.glEnable(32826);
	}
}
