package net.danygames2014.modmenu.gui.widget;

import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.gui.ConfirmChatLinkScreen;
import net.danygames2014.modmenu.gui.ModsScreen;
import net.danygames2014.modmenu.gui.widget.entries.ModMenuEntryListWidget;
import net.danygames2014.modmenu.gui.widget.entries.ModListEntry;
import net.danygames2014.modmenu.util.GlUtil;
import net.danygames2014.modmenu.util.MathUtil;
import net.danygames2014.modmenu.util.ScreenUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.minecraft.class_300;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DescriptionListWidgetModMenu extends ModMenuEntryListWidget {

	private static final String HAS_UPDATE_TEXT = class_300.method_992().method_993("modmenu.hasUpdate");
	private static final String EXPERIMENTAL_TEXT = /*Formatting.GOLD +*/ class_300.method_992().method_993("modmenu.experimental");
	private static final String DOWNLOAD_TEXT = "" + /*Formatting.BLUE + Formatting.UNDERLINE +*/ class_300.method_992().method_993("modmenu.downloadLink");
	private static final String CHILD_HAS_UPDATE_TEXT = class_300.method_992().method_993("modmenu.childHasUpdate");
	private static final String LINKS_TEXT = class_300.method_992().method_993("modmenu.links");
	private static final String SOURCE_TEXT = "" + /*Formatting.BLUE + Formatting.UNDERLINE +*/ class_300.method_992().method_993("modmenu.source");
	private static final String LICENSE_TEXT = class_300.method_992().method_993("modmenu.license");
	private static final String VIEW_CREDITS_TEXT = "" + /*Formatting.BLUE + Formatting.UNDERLINE +*/ class_300.method_992().method_993("modmenu.viewCredits");
	private static final String CREDITS_TEXT = class_300.method_992().method_993("modmenu.credits");

	private final Minecraft field_1528;
	private final ModsScreen parent;
	private final class_34 textRenderer;
	private final List<DescriptionEntry> entries = new ArrayList<>();
	private ModListEntry lastSelected = null;

	public DescriptionListWidgetModMenu(Minecraft client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
		super(client, width, height, top, bottom, entryHeight);
		this.field_1528 = client;
		this.parent = parent;
		this.textRenderer = client.field_2815;
	}

	@Override
	public int getRowWidth() {
		return this.field_1529 - 10;
	}

	@Override
	protected int getScrollbarPosition() {
		return this.field_1529 - 6 + this.field_1532;
	}

	public boolean isMouseInList(int mouseX, int mouseY) {
		return mouseY >= this.field_1535 && mouseY <= this.field_1536 && mouseX >= this.field_1532 && mouseX <= this.field_1531;
	}

	@Override
	public int method_1266() {
		return this.entries.size();
	}

	public void clear() {
		this.entries.clear();
	}

	@Override
	public DescriptionEntry getEntry(int index) {
		return this.entries.get(index);
	}

	@Override
	public void method_1256(int mouseX, int mouseY, float delta) {
		this.mouseX = mouseX;
		this.mouseY = mouseY;
		method_1263();
		ModListEntry selectedEntry = parent.getSelectedEntry();
		if (selectedEntry != lastSelected) {
			lastSelected = selectedEntry;
			clear();
			// Prevent text jumping around
			// scroll(-Integer.MAX_VALUE);
			if (lastSelected != null) {
				DescriptionEntry emptyEntry = new DescriptionEntry("");
				int wrapWidth = getRowWidth() - 5;

				Mod mod = lastSelected.getMod();
				String description = mod.getTranslatedDescription();
				if (!description.isEmpty()) {
					for (Object line : textRenderer.split(description.replaceAll("\n", "\n\n"), wrapWidth)) {
						this.entries.add(new DescriptionEntry((String) line));
					}
				}

				Map<String, String> links = mod.getLinks();
				String sourceLink = mod.getSource();
				if ((!links.isEmpty() || sourceLink != null) && !ModMenuConfig.HIDE_MOD_LINKS.getValue()) {
					this.entries.add(emptyEntry);

					for (Object line : textRenderer.split(LINKS_TEXT, wrapWidth)) {
						this.entries.add(new DescriptionEntry((String) line));
					}

					if (sourceLink != null) {
						int indent = 8;
						for (Object line : textRenderer.split(SOURCE_TEXT, wrapWidth - 16)) {
							this.entries.add(new LinkEntry((String) line, sourceLink, indent));
							indent = 16;
						}
					}

					links.forEach((key, value) -> {
						int indent = 8;
						for (Object line : textRenderer.split("" + /*Formatting.BLUE + Formatting.UNDERLINE +*/ class_300.method_992().method_993(key), wrapWidth - 16)) {
							this.entries.add(new LinkEntry((String) line, value, indent));
							indent = 16;
						}
					});
				}

				Set<String> licenses = mod.getLicense();
				if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
					this.entries.add(emptyEntry);

					for (Object line : textRenderer.split(LICENSE_TEXT, wrapWidth)) {
						this.entries.add(new DescriptionEntry((String) line));
					}

					for (String license : licenses) {
						int indent = 8;
						for (Object line : textRenderer.split(license, wrapWidth - 16)) {
							this.entries.add(new DescriptionEntry((String) line, indent));
							indent = 16;
						}
					}
				}

				if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
					if ("minecraft".equals(mod.getId())) {
						this.entries.add(emptyEntry);
					} else if (!"java".equals(mod.getId())) {
						SortedMap<String, Set<String>> credits = mod.getCredits();

						if (!credits.isEmpty()) {
							this.entries.add(emptyEntry);

							for (Object line : textRenderer.split(CREDITS_TEXT, wrapWidth)) {
								this.entries.add(new DescriptionEntry((String) line));
							}

							Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();

							while (iterator.hasNext()) {
								int indent = 8;

								Map.Entry<String, Set<String>> role = iterator.next();
								String roleName = role.getKey();

								for (Object line : textRenderer.split(this.creditsRoleText(roleName), wrapWidth - 16)) {
									this.entries.add(new DescriptionEntry((String) line, indent));
									indent = 16;
								}

								for (String contributor : role.getValue()) {
									indent = 16;

									for (Object line : textRenderer.split(contributor, wrapWidth - 24)) {
										this.entries.add(new DescriptionEntry((String) line, indent));
										indent = 24;
									}
								}

								if (iterator.hasNext()) {
									this.entries.add(emptyEntry);
								}
							}
						}
					}
				}
			}
		}

		class_67 bufferBuilder = class_67.field_2054;

		{
			this.field_1528.field_2814.method_1097(this.field_1528.field_2814.method_1100("/gui/background.png"));
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			bufferBuilder.method_1691(GL11.GL_QUADS);
			bufferBuilder.method_1693(0x20, 0x20, 0x20);
            bufferBuilder.method_1688(this.field_1532, this.field_1536, 0.0, (this.field_1532 / 32.0F), ((this.field_1536 + this.scrollAmount) / 32.0F));
            bufferBuilder.method_1688(this.field_1531, this.field_1536, 0.0, (this.field_1531 / 32.0F), ((this.field_1536 + this.scrollAmount) / 32.0F));
            bufferBuilder.method_1688(this.field_1531, this.field_1535, 0.0, (this.field_1531 / 32.0F), ((this.field_1535 + this.scrollAmount) / 32.0F));
            bufferBuilder.method_1688(this.field_1532, this.field_1535, 0.0, (this.field_1532 / 32.0F), ((this.field_1535 + this.scrollAmount) / 32.0F));
			bufferBuilder.method_1685();
		}

		int listX = this.field_1532 + this.field_1529 / 2 - this.getRowWidth() / 2 + 2;
		int listY = this.field_1535 + 4 - (int)this.scrollAmount;
		this.renderList(listX, listY, mouseX, mouseY);

		GL11.glDepthFunc(GL11.GL_LEQUAL);
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		GL11.glEnable(GL11.GL_BLEND);
		GlUtil.blendFuncSeparate(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ZERO, GL11.GL_ONE);
		GL11.glDisable(GL11.GL_ALPHA_TEST);
		GL11.glShadeModel(GL11.GL_SMOOTH);
		GL11.glDisable(GL11.GL_TEXTURE_2D);

		bufferBuilder.method_1691(GL11.GL_QUADS);
		bufferBuilder.method_1694(0, 0, 0, 0);
		bufferBuilder.method_1688(this.field_1532, this.field_1535 + 4, 0.0, 0.0, 1.0);
		bufferBuilder.method_1688(this.field_1531, this.field_1535 + 4, 0.0, 1.0, 1.0);
		bufferBuilder.method_1694(0, 0, 0, 255);
		bufferBuilder.method_1688(this.field_1531, this.field_1535, 0.0, 1.0, 0.0);
		bufferBuilder.method_1688(this.field_1532, this.field_1535, 0.0, 0.0, 0.0);
		bufferBuilder.method_1685();
		bufferBuilder.method_1691(GL11.GL_QUADS);
		bufferBuilder.method_1694(0, 0, 0, 255);
		bufferBuilder.method_1688(this.field_1532, this.field_1536, 0.0, 0.0, 1.0);
		bufferBuilder.method_1688(this.field_1531, this.field_1536, 0.0, 1.0, 1.0);
		bufferBuilder.method_1694(0, 0, 0, 0);
		bufferBuilder.method_1688(this.field_1531, this.field_1536 - 4, 0.0, 1.0, 0.0);
		bufferBuilder.method_1688(this.field_1532, this.field_1536 - 4, 0.0, 0.0, 0.0);
		bufferBuilder.method_1685();

		this.renderScrollBar(bufferBuilder);

		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glShadeModel(GL11.GL_FLAT);
		GL11.glEnable(GL11.GL_ALPHA_TEST);
		GL11.glDisable(GL11.GL_BLEND);
	}

	public void handleMouse() {
		int size = this.method_1266();
		int scrollbarMinX = this.getScrollbarPosition();
		int scrollbarMaxX = scrollbarMinX + 6;
		if (mouseX > this.field_1532 && mouseX < this.field_1531 && mouseY > this.field_1535 && mouseY < this.field_1536) {
			if (Mouse.isButtonDown(0)) {
				if (this.field_1538 == -1.0f) {
					int mouseClickMode = 1;
					if (mouseY >= this.field_1535 && mouseY <= this.field_1536) {
						int rowMinX = this.field_1529 / 2 - this.getRowWidth() / 2;
						int rowMaxX = this.field_1529 / 2 + this.getRowWidth() / 2;
						int selectedY = mouseY - this.field_1535 - this.field_1545 + (int) this.scrollAmount - 4;
						int selectedPos = selectedY / this.field_1537;
						if (mouseX >= rowMinX && mouseX <= rowMaxX && selectedPos >= 0 && selectedY >= 0 && selectedPos < size) {
							int selectedIndex = selectedPos == this.field_1541 && MathUtil.getTime() - this.field_1542 < 250L ? 1 : 0;
							this.method_1267(selectedPos, selectedIndex != 0);
							this.field_1541 = selectedPos;
							this.field_1542 = MathUtil.getTime();
						} else if (mouseX >= rowMinX && mouseX <= rowMaxX && selectedY < 0) {
							this.method_1254(mouseX - rowMinX, mouseY - this.field_1535 + (int) this.scrollAmount - 4);
							mouseClickMode = 0;
						}
						if (mouseX >= scrollbarMinX && mouseX <= scrollbarMaxX) {
							this.field_1539 = -1.0f;
							int maxScroll = this.getMaxScroll();
							if (maxScroll < 1) {
								maxScroll = 1;
							}
							int heightForScrolling;
							if ((heightForScrolling = (int) ((float) ((this.field_1536 - this.field_1535) * (this.field_1536 - this.field_1535)) / (float) this.method_1268())) < 32) {
								heightForScrolling = 32;
							}
							if (heightForScrolling > this.field_1536 - this.field_1535 - 8) {
								heightForScrolling = this.field_1536 - this.field_1535 - 8;
							}
							this.field_1539 /= (float) (this.field_1536 - this.field_1535 - heightForScrolling) / (float) maxScroll;
						} else {
							this.field_1539 = 1.0f;
						}
						this.field_1538 = mouseClickMode != 0 ? (float) mouseY : -2.0f;
					} else {
						this.field_1538 = -2.0f;
					}
				} else if (this.field_1538 >= 0.0f) {
					this.scrollAmount -= ((float) mouseY - this.field_1538) * this.field_1539;
					this.field_1538 = mouseY;
				}
			} else {
				int dwheel = Mouse.getEventDWheel();
				if (dwheel != 0) {
					if (dwheel > 0) {
						dwheel = -1;
					} else {
						dwheel = 1;
					}
					this.scrollAmount += dwheel * this.field_1537;
				}

				this.field_1538 = -1.0f;
			}
		}
		this.method_1263();
	}

	@Override
	protected void method_1264(int index, int x, int y, int height, class_67 bufferBuilder) {
		if (y >= this.field_1535 && y + height <= this.field_1536) {
			super.method_1264(index, x, y, height, bufferBuilder);
		}
	}

	public void renderScrollBar(class_67 bufferBuilder) {
		int scrollbarStartX = this.getScrollbarPosition();
		int scrollbarEndX = scrollbarStartX + 6;
		int maxScroll = this.getMaxScroll();
		if (maxScroll > 0) {
			int p = (int) ((float) ((this.field_1536 - this.field_1535) * (this.field_1536 - this.field_1535)) / (float) this.getMaxScroll());
			p = MathUtil.clamp(p, 32, this.field_1536 - this.field_1535 - 8);
			int q = (int) this.getScrollAmount() * (this.field_1536 - this.field_1535 - p) / maxScroll + this.field_1535;
			if (q < this.field_1535) {
				q = this.field_1535;
			}

			bufferBuilder.method_1691(GL11.GL_QUADS);
			bufferBuilder.method_1694(0, 0, 0, 0xFF);
			bufferBuilder.method_1688(scrollbarStartX, this.field_1536, 0.0, 0.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX, this.field_1536, 0.0, 1.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX, this.field_1535, 0.0, 1.0, 0.0);
			bufferBuilder.method_1688(scrollbarStartX, this.field_1535, 0.0, 0.0, 0.0);
			bufferBuilder.method_1685();
			bufferBuilder.method_1691(GL11.GL_QUADS);
			bufferBuilder.method_1694(0x80, 0x80, 0x80, 0xFF);
			bufferBuilder.method_1688(scrollbarStartX, q + p, 0.0, 0.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX, q + p, 0.0, 1.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX, q, 0.0, 1.0, 0.0);
			bufferBuilder.method_1688(scrollbarStartX, q, 0.0, 0.0, 0.0);
			bufferBuilder.method_1685();
			bufferBuilder.method_1691(GL11.GL_QUADS);
			bufferBuilder.method_1694(0xC0, 0xC0, 0xC0, 0xFF);
			bufferBuilder.method_1688(scrollbarStartX, q + p - 1, 0.0, 0.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX - 1, q + p - 1, 0.0, 1.0, 1.0);
			bufferBuilder.method_1688(scrollbarEndX - 1, q, 0.0, 1.0, 0.0);
			bufferBuilder.method_1688(scrollbarStartX, q, 0.0, 0.0, 0.0);
			bufferBuilder.method_1685();
		}
	}

	public void confirmResult(boolean result, int id) {
		if (result) {
			int index = id - ModsScreen.MODS_LIST_CONFIRM_ID_OFFSET;
			List<DescriptionEntry> entries = this.entries;

			if (index >= 0 && index < entries.size()) {
				DescriptionEntry entry = entries.get(index);

				if (entry instanceof LinkEntry) {
					String link = ((LinkEntry) entry).link;
					ScreenUtil.openLink(parent, link, parent.getSelectedEntry().mod.getId() + "/link");
				}
			}
		}

		field_1528.method_2112(this.parent);
	}

	private String creditsRoleText(String roleName) {
		// Replace spaces and dashes in role names with underscores if they exist
		// Notably Quilted Fabric API does this with FabricMC as "Upstream Owner"
		String translationKey = roleName.replaceAll("[\\s-]", "_").toLowerCase();

		return class_300.method_992().method_993("modmenu.credits.role." + translationKey) + ":";
	}

	protected class DescriptionEntry implements ModMenuEntryListWidget.Entry {
		protected String text;
		protected int indent;
		public boolean updateTextEntry = false;

		public DescriptionEntry(String text, int indent) {
			this.text = text;
			this.indent = indent;
		}

		public DescriptionEntry(String text) {
			this(text, 0);
		}

		public DescriptionEntry setUpdateTextEntry() {
			this.updateTextEntry = true;
			return this;
		}

		@Override
		public void render(int index, int x, int y, int width, int height, class_67 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
			textRenderer.method_1903(text, x + indent, y, 0xAAAAAA);
		}

		@Override
		public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
			return false;
		}

		@Override
		public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
		}
	}

	protected class LinkEntry extends DescriptionEntry {
		private final String link;

		public LinkEntry(String text, String link, int indent) {
			super(text, indent);
			this.link = link;
		}

		public LinkEntry(String text, String link) {
			this(text, link, 0);
		}

		@Override
		public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
			if (isMouseInList(mouseX, mouseY)) {
				field_1528.method_2112(new ConfirmChatLinkScreen(DescriptionListWidgetModMenu.this.parent, link, ModsScreen.MODS_LIST_CONFIRM_ID_OFFSET + index) {

					@Override
					public void copy() {
					}
				});
			}
			return super.mouseClicked(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
		}
	}

}
