package net.danygames2014.modmenu.gui.widget.entries;

import java.awt.image.BufferedImage;
import java.nio.BufferOverflowException;
import org.lwjgl.opengl.GL11;

import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.gui.widget.ModListWidgetModMenu;
import net.danygames2014.modmenu.util.DrawingUtil;
import net.danygames2014.modmenu.util.MathUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.danygames2014.modmenu.util.mod.ModBadgeRenderer;
import net.minecraft.class_300;
import net.minecraft.class_34;
import net.minecraft.class_584;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;

public class ModListEntry extends class_584 implements ModMenuEntryListWidget.Entry {
	public static final String UNKNOWN_ICON = "/gui/unknown_pack.png";
	private static final String MOD_CONFIGURATION_ICON = "/assets/modmenu/textures/gui/mod_configuration.png";
//	private static final String ERROR_ICON = new Identifier("minecraft", "textures/gui/world_selection.png");
	private static final String ERROR_ICON = "/assets/modmenu/textures/gui/world_selection.png";

	protected final Minecraft client;
	public final Mod mod;
	protected final ModListWidgetModMenu list;
	protected Integer iconGlId;
	protected static final int FULL_ICON_SIZE = 32;
	protected static final int COMPACT_ICON_SIZE = 19;
	protected long sinceLastClick;

	public ModListEntry(Mod mod, ModListWidgetModMenu list) {
		this.mod = mod;
		this.list = list;
		this.client = Minecraft.field_2791;
	}

	@Override
	public void render(int index, int x, int y, int rowWidth, int rowHeight, class_67 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
		x += getXOffset();
		rowWidth -= getXOffset();
		int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? COMPACT_ICON_SIZE : FULL_ICON_SIZE;
		String modId = mod.getId();
		if ("java".equals(modId)) {
			DrawingUtil.drawRandomVersionBackground(mod, x, y, iconSize, iconSize);
		}
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		GL11.glEnable(GL11.GL_BLEND);
		this.bindIconTexture();
		DrawingUtil.drawTexture(x, y, 0.0F, 0.0F, iconSize, iconSize, iconSize, iconSize);
		GL11.glDisable(GL11.GL_BLEND);
		String name = mod.getTranslatedName();
		String trimmedName = name;
		int maxNameWidth = rowWidth - iconSize - 3;
		class_34 font = this.client.field_2815;
		if (font.method_1901(name) > maxNameWidth) {
			String ellipsis = "...";
			trimmedName = font.trim(name, maxNameWidth - font.method_1901(ellipsis)) + ellipsis;
		}
		font.method_1906(trimmedName, x + iconSize + 3, y + 1, 0xFFFFFF);
		int updateBadgeXOffset = 0;
		if (!ModMenuConfig.HIDE_BADGES.getValue()) {
			new ModBadgeRenderer(x + iconSize + 3 + font.method_1901(name) + 2 + updateBadgeXOffset, y, x + rowWidth, mod, list.getParent()).draw(mouseX, mouseY);
		}
		if (!ModMenuConfig.COMPACT_LIST.getValue()) {
			String summary = mod.getSummary();
			DrawingUtil.drawWrappedString(summary, (x + iconSize + 3 + 4), (y + DrawingUtil.fontHeight + 2), rowWidth - iconSize - 7, 2, 0x808080);
		} else {
			DrawingUtil.drawWrappedString(mod.getPrefixedVersion(), (x + iconSize + 3), (y + DrawingUtil.fontHeight + 2), rowWidth - iconSize - 7, 2, 0x808080);
		}

		if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen().get(modId) || this.list.getParent().modScreenErrors.containsKey(modId))) {
			final int textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? (int) (256 / (FULL_ICON_SIZE / (double) COMPACT_ICON_SIZE)) : 256;
			if (/*this.client.options.touchscreen ||*/ hovered) {
				this.method_1932(x, y, x + iconSize, y + iconSize, -1601138544);
				boolean hoveringIcon = mouseX - x < iconSize;
				//System.err.println("mouseX: " + mouseX + " | x: " + x + " | hoveringIcon:" + hoveringIcon);
				int v = hoveringIcon ? iconSize : 0;
				if (this.list.getParent().modScreenErrors.containsKey(modId)) {
					this.client.field_2814.method_1097(this.client.field_2814.method_1100(ERROR_ICON));
					DrawingUtil.drawTexture(x, y, 96.0F, (float) v, iconSize, iconSize, textureSize, textureSize);
					if (hoveringIcon) {
						Throwable e = this.list.getParent().modScreenErrors.get(modId);
						this.list.getParent().setTooltip(this.client.field_2815.split(class_300.method_992().method_994("modmenu.configure.error", modId, modId) + "\n\n" + /*Formatting.RED +*/ e.toString(), 175));
					}
				} else {
					this.client.field_2814.method_1097(this.client.field_2814.method_1100(MOD_CONFIGURATION_ICON));
					DrawingUtil.drawTexture(x, y, 0.0F, (float) v, iconSize, iconSize, textureSize, textureSize);
				}
			}
		}
	}

	@Override
	public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
		list.select(this);
		if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen().get(this.mod.getId())) {
			int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? COMPACT_ICON_SIZE : FULL_ICON_SIZE;
			if (mouseX - list.getRowLeft() <= iconSize) {
				this.openConfig();
			} else if (MathUtil.getTime() - this.sinceLastClick < 250) {
				this.openConfig();
			}
		}
		this.sinceLastClick = MathUtil.getTime();
		return true;
	}

	@Override
	public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
	}

	public boolean keyPressed(char chr, int key) {
		return false;
	}

	public void openConfig() {
		client.method_2112(ModMenu.getConfigScreen(mod.getId(), list.getParent()));
	}

	public Mod getMod() {
		return mod;
	}

	public void bindIconTexture() {
		if (this.iconGlId == null) {
			BufferedImage icon = mod.getIcon(list.getFabricIconHandler(), 64 * this.client.field_2824.field_1450);

            try {
                this.iconGlId = this.client.field_2814.method_1088(icon);
            } catch (BufferOverflowException e) {
                this.iconGlId = this.client.field_2814.method_1100(UNKNOWN_ICON);
            }
        }
        
		this.client.field_2814.method_1097(this.iconGlId);
	}

	public int getXOffset() {
		return 0;
	}
}
