package net.danygames2014.modmenu.mixin;

import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.api.ModMenuApi;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.gui.ModsScreen;
import net.danygames2014.modmenu.gui.widget.ModMenuButtonWidget;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_525;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_525.class)
public abstract class MixinGameMenu extends class_32 {
	/** button id for Options... button */
	private static final int OPTIONS = 0;
	/** button id for gui.achievements button */
	private static final int ACHIEVEMENTS = 5;
	/** button id for gui.stats button */
	private static final int STATS = 6;
	/** button id for modmenu.title button */
	private static final int MODS = 69;
	private static final String FABRIC_ICON_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/mods_button.png";
	@Inject(method = "init", at = @At(value = "TAIL"))
	private void onInit(CallbackInfo ci) {
		if (ModMenuConfig.MODIFY_GAME_MENU.getValue()) {
			final ModMenuConfig.GameMenuButtonStyle style = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
			final int spacing = 4;
			int modsButtonIndex = -1;
			int modsButtonX = -1;
			int modsButtonY = -1;
			int modsButtonWidth = -1;
			int modsButtonHeight = 20;
			for (int i = 0; i < this.field_154.size(); i++) {
				final class_33 button = (class_33) this.field_154.get(i);
				if (style == ModMenuConfig.GameMenuButtonStyle.BELOW_ACHIEVEMENTS && button.field_1373 == ACHIEVEMENTS) {
					modsButtonX = button.field_1370;
					modsButtonWidth = button.field_1368;
				}
				if (style == ModMenuConfig.GameMenuButtonStyle.BELOW_STATISTICS && button.field_1373 == STATS) {
					modsButtonX = button.field_1370;
					modsButtonWidth = button.field_1368;
				}
				if (style == ModMenuConfig.GameMenuButtonStyle.BELOW_ACHIEVEMENTS_AND_STATISTICS && button.field_1373 == ACHIEVEMENTS) {
					modsButtonX = button.field_1370;
					modsButtonWidth = 2 * button.field_1368 + spacing;
				}
				if (style == ModMenuConfig.GameMenuButtonStyle.ICON && button.field_1373 == STATS) {
					modsButtonX = button.field_1370 + (button.field_1368 + spacing);
					modsButtonWidth = modsButtonHeight;
				}
				if (button.field_1373 == OPTIONS) {
					modsButtonIndex = i + 1;
					if (style == ModMenuConfig.GameMenuButtonStyle.ICON) {
						modsButtonY = button.field_1371;
					} else {
						modsButtonY = button.field_1371 - spacing - modsButtonHeight;
					}
				}
			}
			if (modsButtonIndex != -1) {
				if (style == ModMenuConfig.GameMenuButtonStyle.ICON) {
				} else {
					this.field_154.add(new ModMenuButtonWidget(MODS, modsButtonX, modsButtonY, modsButtonWidth, modsButtonHeight, ModMenuApi.createModsButtonText()));
				}
			}
		}
	}

	@Inject(method = "buttonClicked", at = @At(value = "HEAD"))
	private void onButtonClicked(class_33 button, CallbackInfo ci) {
		if (button.field_1373 == MODS) {
			this.field_151.method_2112(new ModsScreen(this));
		}
	}
}
