package net.danygames2014.modmenu.mixin;

import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.api.ModMenuApi;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.event.ModMenuEventHandler;
import net.danygames2014.modmenu.gui.ModsScreen;
import net.danygames2014.modmenu.gui.widget.ModMenuButtonWidget;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.minecraft.class_197;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_197.class, priority = 1001)
public abstract class MixinTitleScreen extends class_32 {
	/** button id for menu.mods button */
	private static final int TEXTURE_PACKS = 3;
	/** button id for modmenu.title button */
	private static final int MODS = 69;
	private static final String FABRIC_ICON_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/mods_button.png";

	@Inject(at = @At(value = "TAIL"), method = "init")
	private void onInit(CallbackInfo ci) {
		final List<class_33> buttons = this.field_154;
		if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
			int modsButtonIndex = -1;
			final int spacing = 24;
			int buttonsY = this.field_153 / 4 + 48;
			for (int i = 0; i < buttons.size(); i++) {
				class_33 button = buttons.get(i);
				if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
					if (button.field_1375) {
						ModMenuEventHandler.shiftButtons(button, modsButtonIndex == -1, spacing);
						if (modsButtonIndex == -1) {
							buttonsY = button.field_1371;
						}
					}
				}
				if (button.field_1373 == TEXTURE_PACKS) {
					if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
						button.field_1368 = 98;
					}
					modsButtonIndex = i + 1;
					if (button.field_1375) {
						buttonsY = button.field_1371;
					}
				}
			}
			if (modsButtonIndex != -1) {
				if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
					this.field_154.add(new ModMenuButtonWidget(MODS, this.field_152 / 2 - 100, buttonsY + spacing, 200, 20, ModMenuApi.createModsButtonText()));
				} else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
					this.field_154.add(new ModMenuButtonWidget(MODS, this.field_152 / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText()));
				}
			}
		}
	}

	@Inject(method = "buttonClicked", at = @At(value = "HEAD"))
	private void onButtonClicked(class_33 button, CallbackInfo ci) {
		if (button.field_1373 == MODS) {
			this.field_151.method_2112(new ModsScreen(this));
		}
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/TitleScreen;drawTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Ljava/lang/String;III)V", ordinal = 0))
	private String onRender(String string) {
		if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue() && ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnTitleScreen()) {
			String count = ModMenu.getDisplayedModCount();
			String specificKey = "modmenu.mods." + count;
			String replacementKey = TranslationUtil.hasTranslation(specificKey) ? specificKey : "modmenu.mods.n";
			if (ModMenuConfig.EASTER_EGGS.getValue() && TranslationUtil.hasTranslation(specificKey + ".secret")) {
				replacementKey = specificKey + ".secret";
			}
			return string + " " + class_300.method_992().method_994(replacementKey, count);
		}
		return string;
	}
}
