/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.config.option;

import net.danygames2014.modmenu.config.option.ConfigOption;
import net.danygames2014.modmenu.config.option.ConfigOptionStorage;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.minecraft.class_300;

public class BooleanConfigOption
implements ConfigOption {
    private final String key;
    private final String translationKey;
    private final boolean defaultValue;
    private final String enabledText;
    private final String disabledText;

    public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.defaultValue = defaultValue;
        this.enabledText = class_300.method_992().method_993(this.translationKey + "." + enabledKey);
        this.disabledText = class_300.method_992().method_993(this.translationKey + "." + disabledKey);
    }

    public BooleanConfigOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false");
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValueLabel() {
        return TranslationUtil.translateOptionLabel(class_300.method_992().method_993(this.translationKey), this.getValue() ? this.enabledText : this.disabledText);
    }

    @Override
    public void click() {
        this.toggleValue();
    }
}

