/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.gui.widget;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.gui.ModsScreen;
import net.danygames2014.modmenu.gui.widget.entries.ChildEntry;
import net.danygames2014.modmenu.gui.widget.entries.IndependentEntry;
import net.danygames2014.modmenu.gui.widget.entries.ModListEntry;
import net.danygames2014.modmenu.gui.widget.entries.ModMenuEntryListWidget;
import net.danygames2014.modmenu.gui.widget.entries.ParentEntry;
import net.danygames2014.modmenu.util.mod.Mod;
import net.danygames2014.modmenu.util.mod.ModSearch;
import net.danygames2014.modmenu.util.mod.fabric.FabricIconHandler;
import net.minecraft.class_189;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ModListWidgetModMenu
extends ModMenuEntryListWidget
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private final List<ModListEntry> entries = new ArrayList<ModListEntry>();
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private final FabricIconHandler iconHandler = new FabricIconHandler();
    private ModListEntry selected;

    public ModListWidgetModMenu(Minecraft client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidgetModMenu list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
        }
        this.filter(searchTerm, false);
        this.scrollAmount = parent.getScrollPercent() * (float)Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4));
        this.method_1263();
    }

    @Override
    public void scroll(int amount) {
        super.scroll(amount);
        int denominator = Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0f);
        } else {
            this.parent.updateScrollPercent(this.getScrollAmount() / Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4)));
        }
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.field_1535 && mouseY <= this.field_1536 && mouseX >= this.field_1532 && mouseX <= this.field_1531;
    }

    protected boolean isFocused() {
        return false;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
    }

    public void setSelected(ModListEntry entry) {
        this.selected = entry;
        this.selectedModId = entry.getMod().getId();
        this.parent.updateSelectedEntry(entry);
    }

    @Override
    protected boolean method_1270(int index) {
        return this.selected != null && this.selected.getMod().getId().equals(this.entries.get(index).getMod().getId());
    }

    public void addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return;
        }
        this.addedMods.add(entry.mod);
        this.entries.add(entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return this.entries.remove(entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(this.entries.get((int)index).mod);
        return this.entries.remove(index);
    }

    public int method_1266() {
        return this.entries.size();
    }

    @Override
    public ModListEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public void clear() {
        this.entries.clear();
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clear();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            Map<String, Boolean> modHasConfigScreen;
            Boolean hasConfig;
            if (ModMenuConfig.CONFIG_MODE.getValue() && !(hasConfig = (modHasConfigScreen = this.parent.getModHasConfigScreen()).get(mod.getId())).booleanValue()) {
                return false;
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
        for (Mod mod2 : matched) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.entries.isEmpty() || this.selected != null && this.selected.getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.entries) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.selected == null && !this.entries.isEmpty() && this.entries.get(0) != null) {
            this.setSelected(this.entries.get(0));
        }
        if (this.getScrollAmount() > Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4))) {
            this.scroll(Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4)));
        }
    }

    @Override
    protected void renderList(int x, int y, int mouseX, int mouseY) {
        int entryCount = this.method_1266();
        class_67 buffer = class_67.field_2054;
        for (int index = 0; index < entryCount; ++index) {
            int entryTop = this.getRowTop(index);
            int entryBottom = this.getRowTop(index) + this.field_1537;
            if (entryBottom < this.field_1535 || entryTop > this.field_1536) continue;
            int entryHeight = this.field_1537 - 4;
            ModListEntry entry = this.entries.get(index);
            int rowWidth = this.getRowWidth();
            if (this.method_1270(index)) {
                int entryLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = this.getRowLeft() + rowWidth + 2;
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                GL11.glDisable((int)3553);
                GL11.glColor4f((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                buffer.method_1691(7);
                buffer.method_1687((double)entryLeft, (double)(entryTop + entryHeight + 2), 0.0);
                buffer.method_1687((double)selectionRight, (double)(entryTop + entryHeight + 2), 0.0);
                buffer.method_1687((double)selectionRight, (double)(entryTop - 2), 0.0);
                buffer.method_1687((double)entryLeft, (double)(entryTop - 2), 0.0);
                buffer.method_1685();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.method_1691(7);
                buffer.method_1687((double)(entryLeft + 1), (double)(entryTop + entryHeight + 1), 0.0);
                buffer.method_1687((double)(selectionRight - 1), (double)(entryTop + entryHeight + 1), 0.0);
                buffer.method_1687((double)(selectionRight - 1), (double)(entryTop - 1), 0.0);
                buffer.method_1687((double)(entryLeft + 1), (double)(entryTop - 1), 0.0);
                buffer.method_1685();
                GL11.glEnable((int)3553);
            }
            this.method_1264(index, this.getRowLeft(), entryTop, entryHeight, buffer);
        }
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    @Override
    public boolean mouseClicked(int double_1, int double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseInList(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.mouseClicked(this.entries.indexOf(entry), double_1, double_2, int_1, double_1, double_2)) {
                this.select(entry);
                return true;
            }
        } else if (int_1 == 0) {
            this.method_1254((int)((double)double_1 - (double)(this.field_1532 + this.field_1529 / 2 - this.getRowWidth() / 2)), (int)((double)double_2 - (double)this.field_1535) + this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean keyPressed(char chr, int key) {
        if (this.selected != null) {
            int index = this.entries.indexOf(this.selected);
            if (key == 200) {
                if (--index < 0) {
                    index = this.method_1266() - 1;
                }
                this.select(this.entries.get(index));
                return true;
            }
            if (key == 208) {
                if (++index >= this.method_1266()) {
                    index = 0;
                }
                this.select(this.entries.get(index));
                return true;
            }
            return this.selected.keyPressed(chr, key);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_189.method_645((double)(y - (double)this.field_1535)) - this.field_1545 + this.getScrollAmount() - 4;
        int index = int_5 / this.field_1537;
        return x < (double)this.getScrollbarPosition() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.method_1266() ? this.entries.get(index) : null;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.field_1529 - 6;
    }

    @Override
    public int getRowWidth() {
        return this.field_1529 - (Math.max(0, this.getMaxScroll() - (this.field_1536 - this.field_1535 - 4)) > 0 ? 18 : 12);
    }

    public int getRowLeft() {
        return this.field_1532 + 6;
    }

    public int getRowTop(int index) {
        return this.field_1535 + 4 - this.getScrollAmount() + index * this.field_1537 + this.field_1545;
    }

    public int getWidth() {
        return this.field_1529;
    }

    public int getTop() {
        return this.field_1535;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    @Override
    public int getMaxScroll() {
        return super.getMaxScroll() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.entries) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

