/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.util;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public final class VersionUtil {
    private static final List<String> PREFIXES = Arrays.asList("version", "ver", "v");

    private VersionUtil() {
    }

    public static String stripPrefix(String version) {
        version = version.trim();
        for (String prefix : PREFIXES) {
            if (!version.startsWith(prefix)) continue;
            return version.substring(prefix.length());
        }
        return version;
    }

    public static String getPrefixedVersion(String version) {
        return "v" + VersionUtil.stripPrefix(version);
    }

    public static String removeBuildMetadata(String version) {
        return version.split("\\+")[0];
    }

    public static String getModrinthCompatibleMcVersion() {
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
        if (version.startsWith("1.0.0-alpha.")) {
            return "a1." + version.substring(12);
        }
        if (version.startsWith("1.0.0-beta.")) {
            return "b1." + version.substring(11);
        }
        if (version.equals("1.0.0")) {
            return "1.0";
        }
        return version;
    }
}

