/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.danygames2014.modmenu.api.ConfigScreenFactory;
import net.danygames2014.modmenu.api.ModMenuApi;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.config.ModMenuConfigManager;
import net.danygames2014.modmenu.event.ModMenuEventHandler;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.danygames2014.modmenu.util.mod.fabric.FabricDummyParentMod;
import net.danygames2014.modmenu.util.mod.fabric.FabricMod;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_300;
import net.minecraft.class_32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final Gson GSON_MINIFIED = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final Map<String, Mod> MODS = new HashMap<String, Mod>();
    public static final Map<String, Mod> ROOT_MODS = new HashMap<String, Mod>();
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
    private static final Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap();
    private static final List<ModMenuApi> apiImplementations = new ArrayList<ModMenuApi>();
    private static int cachedDisplayedModCount = -1;
    public static boolean devEnvironment = FabricLoader.getInstance().isDevelopmentEnvironment();

    public static class_32 getConfigScreen(String modid, class_32 menuScreen) {
        for (ModMenuApi api : apiImplementations) {
            Map<String, ConfigScreenFactory<?>> factoryProviders = api.getProvidedConfigScreenFactories();
            if (factoryProviders.isEmpty()) continue;
            factoryProviders.forEach(configScreenFactories::putIfAbsent);
        }
        if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
            return null;
        }
        ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        return null;
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        HashSet<String> modpackMods = new HashSet<String>();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
                configScreenFactories.put(modId, api.getModConfigScreenFactory());
                apiImplementations.add(api);
                api.attachModpackBadges(modpackMods::add);
            }
            catch (Throwable e) {
                LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", (Object)modId, (Object)e);
            }
        });
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            Mod mod = new FabricMod(modContainer, modpackMods);
            MODS.put(mod.getId(), mod);
        }
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        for (Mod mod : MODS.values()) {
            String parentId = mod.getParent();
            if (parentId != null) {
                Mod parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId));
                if (parent == null && mod instanceof FabricMod) {
                    parent = new FabricDummyParentMod((FabricMod)mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                PARENT_MAP.put((Object)parent, (Object)mod);
                continue;
            }
            ROOT_MODS.put(mod.getId(), mod);
        }
        MODS.putAll(dummyParents);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> !(!ModMenuConfig.COUNT_CHILDREN.getValue() && mod.getParent() != null || !ModMenuConfig.COUNT_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !ModMenuConfig.COUNT_HIDDEN_MODS.getValue() && mod.isHidden())).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static String createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : false;
        Object modsText = class_300.method_992().method_993("modmenu.title");
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText = (String)modsText + " " + class_300.method_992().method_994("modmenu.loaded.short", new Object[]{count});
            } else {
                Object key;
                String specificKey = "modmenu.loaded." + count;
                Object object = key = TranslationUtil.hasTranslation(specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && TranslationUtil.hasTranslation(specificKey + ".secret")) {
                    key = specificKey + ".secret";
                }
                modsText = (String)modsText + " " + class_300.method_992().method_994((String)key, new Object[]{count});
            }
        }
        return modsText;
    }
}

