/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.gui.widget;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.gui.ConfirmChatLinkScreen;
import net.danygames2014.modmenu.gui.ModsScreen;
import net.danygames2014.modmenu.gui.widget.entries.ModListEntry;
import net.danygames2014.modmenu.gui.widget.entries.ModMenuEntryListWidget;
import net.danygames2014.modmenu.util.GlUtil;
import net.danygames2014.modmenu.util.MathUtil;
import net.danygames2014.modmenu.util.ScreenUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DescriptionListWidgetModMenu
extends ModMenuEntryListWidget {
    private static final String HAS_UPDATE_TEXT = class_300.method_992().method_993("modmenu.hasUpdate");
    private static final String EXPERIMENTAL_TEXT = class_300.method_992().method_993("modmenu.experimental");
    private static final String DOWNLOAD_TEXT = class_300.method_992().method_993("modmenu.downloadLink");
    private static final String CHILD_HAS_UPDATE_TEXT = class_300.method_992().method_993("modmenu.childHasUpdate");
    private static final String LINKS_TEXT = class_300.method_992().method_993("modmenu.links");
    private static final String SOURCE_TEXT = class_300.method_992().method_993("modmenu.source");
    private static final String LICENSE_TEXT = class_300.method_992().method_993("modmenu.license");
    private static final String VIEW_CREDITS_TEXT = class_300.method_992().method_993("modmenu.viewCredits");
    private static final String CREDITS_TEXT = class_300.method_992().method_993("modmenu.credits");
    private final Minecraft minecraft;
    private final ModsScreen parent;
    private final class_34 textRenderer;
    private final List<DescriptionEntry> entries = new ArrayList<DescriptionEntry>();
    private ModListEntry lastSelected = null;

    public DescriptionListWidgetModMenu(Minecraft client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.minecraft = client;
        this.parent = parent;
        this.textRenderer = client.field_2815;
    }

    @Override
    public int getRowWidth() {
        return this.field_1529 - 10;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.field_1529 - 6 + this.field_1532;
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.field_1535 && mouseY <= this.field_1536 && mouseX >= this.field_1532 && mouseX <= this.field_1531;
    }

    public int method_1266() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    @Override
    public DescriptionEntry getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public void method_1256(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.method_1263();
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clear();
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry("");
                int wrapWidth = this.getRowWidth() - 5;
                Mod mod = this.lastSelected.getMod();
                String description = mod.getTranslatedDescription();
                if (!description.isEmpty()) {
                    for (Object line : this.textRenderer.split(description.replaceAll("\n", "\n\n"), wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.entries.add(emptyEntry);
                    for (Object line : this.textRenderer.split(LINKS_TEXT, wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object e : this.textRenderer.split(SOURCE_TEXT, wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)e, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (Object line : this.textRenderer.split(class_300.method_992().method_993(key), wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.entries.add(emptyEntry);
                    for (Object e : this.textRenderer.split(LICENSE_TEXT, wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)e));
                    }
                    for (String string : licenses) {
                        int indent = 8;
                        for (Object line : this.textRenderer.split(string, wrapWidth - 16)) {
                            this.entries.add(new DescriptionEntry((String)line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    SortedMap<String, Set<String>> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.entries.add(emptyEntry);
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.entries.add(emptyEntry);
                        for (Object line : this.textRenderer.split(CREDITS_TEXT, wrapWidth)) {
                            this.entries.add(new DescriptionEntry((String)line));
                        }
                        Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
                        while (iterator.hasNext()) {
                            int indent = 8;
                            Map.Entry<String, Set<String>> role = iterator.next();
                            String roleName = role.getKey();
                            for (Object line : this.textRenderer.split(this.creditsRoleText(roleName), wrapWidth - 16)) {
                                this.entries.add(new DescriptionEntry((String)line, indent));
                                indent = 16;
                            }
                            for (String contributor : role.getValue()) {
                                indent = 16;
                                for (Object line : this.textRenderer.split(contributor, wrapWidth - 24)) {
                                    this.entries.add(new DescriptionEntry((String)line, indent));
                                    indent = 24;
                                }
                            }
                            if (!iterator.hasNext()) continue;
                            this.entries.add(emptyEntry);
                        }
                    }
                }
            }
        }
        class_67 bufferBuilder = class_67.field_2054;
        this.minecraft.field_2814.method_1097(this.minecraft.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1691(7);
        bufferBuilder.method_1693(32, 32, 32);
        bufferBuilder.method_1688((double)this.field_1532, (double)this.field_1536, 0.0, (double)((float)this.field_1532 / 32.0f), ((double)this.field_1536 + this.scrollAmount) / 32.0);
        bufferBuilder.method_1688((double)this.field_1531, (double)this.field_1536, 0.0, (double)((float)this.field_1531 / 32.0f), ((double)this.field_1536 + this.scrollAmount) / 32.0);
        bufferBuilder.method_1688((double)this.field_1531, (double)this.field_1535, 0.0, (double)((float)this.field_1531 / 32.0f), ((double)this.field_1535 + this.scrollAmount) / 32.0);
        bufferBuilder.method_1688((double)this.field_1532, (double)this.field_1535, 0.0, (double)((float)this.field_1532 / 32.0f), ((double)this.field_1535 + this.scrollAmount) / 32.0);
        bufferBuilder.method_1685();
        int listX = this.field_1532 + this.field_1529 / 2 - this.getRowWidth() / 2 + 2;
        int listY = this.field_1535 + 4 - (int)this.scrollAmount;
        this.renderList(listX, listY, mouseX, mouseY);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GlUtil.blendFuncSeparate(770, 771, 0, 1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        bufferBuilder.method_1691(7);
        bufferBuilder.method_1694(0, 0, 0, 0);
        bufferBuilder.method_1688((double)this.field_1532, (double)(this.field_1535 + 4), 0.0, 0.0, 1.0);
        bufferBuilder.method_1688((double)this.field_1531, (double)(this.field_1535 + 4), 0.0, 1.0, 1.0);
        bufferBuilder.method_1694(0, 0, 0, 255);
        bufferBuilder.method_1688((double)this.field_1531, (double)this.field_1535, 0.0, 1.0, 0.0);
        bufferBuilder.method_1688((double)this.field_1532, (double)this.field_1535, 0.0, 0.0, 0.0);
        bufferBuilder.method_1685();
        bufferBuilder.method_1691(7);
        bufferBuilder.method_1694(0, 0, 0, 255);
        bufferBuilder.method_1688((double)this.field_1532, (double)this.field_1536, 0.0, 0.0, 1.0);
        bufferBuilder.method_1688((double)this.field_1531, (double)this.field_1536, 0.0, 1.0, 1.0);
        bufferBuilder.method_1694(0, 0, 0, 0);
        bufferBuilder.method_1688((double)this.field_1531, (double)(this.field_1536 - 4), 0.0, 1.0, 0.0);
        bufferBuilder.method_1688((double)this.field_1532, (double)(this.field_1536 - 4), 0.0, 0.0, 0.0);
        bufferBuilder.method_1685();
        this.renderScrollBar(bufferBuilder);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void handleMouse() {
        int size = this.method_1266();
        int scrollbarMinX = this.getScrollbarPosition();
        int scrollbarMaxX = scrollbarMinX + 6;
        if (this.mouseX > this.field_1532 && this.mouseX < this.field_1531 && this.mouseY > this.field_1535 && this.mouseY < this.field_1536) {
            if (Mouse.isButtonDown((int)0)) {
                if (this.field_1538 == -1.0f) {
                    boolean mouseClickMode = true;
                    if (this.mouseY >= this.field_1535 && this.mouseY <= this.field_1536) {
                        int rowMinX = this.field_1529 / 2 - this.getRowWidth() / 2;
                        int rowMaxX = this.field_1529 / 2 + this.getRowWidth() / 2;
                        int selectedY = this.mouseY - this.field_1535 - this.field_1545 + (int)this.scrollAmount - 4;
                        int selectedPos = selectedY / this.field_1537;
                        if (this.mouseX >= rowMinX && this.mouseX <= rowMaxX && selectedPos >= 0 && selectedY >= 0 && selectedPos < size) {
                            boolean selectedIndex = selectedPos == this.field_1541 && MathUtil.getTime() - this.field_1542 < 250L;
                            this.method_1267(selectedPos, selectedIndex);
                            this.field_1541 = selectedPos;
                            this.field_1542 = MathUtil.getTime();
                        } else if (this.mouseX >= rowMinX && this.mouseX <= rowMaxX && selectedY < 0) {
                            this.method_1254(this.mouseX - rowMinX, this.mouseY - this.field_1535 + (int)this.scrollAmount - 4);
                            mouseClickMode = false;
                        }
                        if (this.mouseX >= scrollbarMinX && this.mouseX <= scrollbarMaxX) {
                            int heightForScrolling;
                            this.field_1539 = -1.0f;
                            int maxScroll = this.getMaxScroll();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            if ((heightForScrolling = (int)((float)((this.field_1536 - this.field_1535) * (this.field_1536 - this.field_1535)) / (float)this.method_1268())) < 32) {
                                heightForScrolling = 32;
                            }
                            if (heightForScrolling > this.field_1536 - this.field_1535 - 8) {
                                heightForScrolling = this.field_1536 - this.field_1535 - 8;
                            }
                            this.field_1539 /= (float)(this.field_1536 - this.field_1535 - heightForScrolling) / (float)maxScroll;
                        } else {
                            this.field_1539 = 1.0f;
                        }
                        this.field_1538 = mouseClickMode ? (float)this.mouseY : -2.0f;
                    } else {
                        this.field_1538 = -2.0f;
                    }
                } else if (this.field_1538 >= 0.0f) {
                    this.scrollAmount -= (double)(((float)this.mouseY - this.field_1538) * this.field_1539);
                    this.field_1538 = this.mouseY;
                }
            } else {
                int dwheel = Mouse.getEventDWheel();
                if (dwheel != 0) {
                    dwheel = dwheel > 0 ? -1 : 1;
                    this.scrollAmount += (double)(dwheel * this.field_1537);
                }
                this.field_1538 = -1.0f;
            }
        }
        this.method_1263();
    }

    @Override
    protected void method_1264(int index, int x, int y, int height, class_67 bufferBuilder) {
        if (y >= this.field_1535 && y + height <= this.field_1536) {
            super.method_1264(index, x, y, height, bufferBuilder);
        }
    }

    public void renderScrollBar(class_67 bufferBuilder) {
        int scrollbarStartX = this.getScrollbarPosition();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int p = (int)((float)((this.field_1536 - this.field_1535) * (this.field_1536 - this.field_1535)) / (float)this.getMaxScroll());
            p = MathUtil.clamp(p, 32, this.field_1536 - this.field_1535 - 8);
            int q = this.getScrollAmount() * (this.field_1536 - this.field_1535 - p) / maxScroll + this.field_1535;
            if (q < this.field_1535) {
                q = this.field_1535;
            }
            bufferBuilder.method_1691(7);
            bufferBuilder.method_1694(0, 0, 0, 255);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)this.field_1536, 0.0, 0.0, 1.0);
            bufferBuilder.method_1688((double)scrollbarEndX, (double)this.field_1536, 0.0, 1.0, 1.0);
            bufferBuilder.method_1688((double)scrollbarEndX, (double)this.field_1535, 0.0, 1.0, 0.0);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)this.field_1535, 0.0, 0.0, 0.0);
            bufferBuilder.method_1685();
            bufferBuilder.method_1691(7);
            bufferBuilder.method_1694(128, 128, 128, 255);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)(q + p), 0.0, 0.0, 1.0);
            bufferBuilder.method_1688((double)scrollbarEndX, (double)(q + p), 0.0, 1.0, 1.0);
            bufferBuilder.method_1688((double)scrollbarEndX, (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            bufferBuilder.method_1685();
            bufferBuilder.method_1691(7);
            bufferBuilder.method_1694(192, 192, 192, 255);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)(q + p - 1), 0.0, 0.0, 1.0);
            bufferBuilder.method_1688((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0, 1.0, 1.0);
            bufferBuilder.method_1688((double)(scrollbarEndX - 1), (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.method_1688((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            bufferBuilder.method_1685();
        }
    }

    public void confirmResult(boolean result, int id) {
        if (result) {
            DescriptionEntry entry;
            int index = id - 10;
            List<DescriptionEntry> entries = this.entries;
            if (index >= 0 && index < entries.size() && (entry = entries.get(index)) instanceof LinkEntry) {
                String link = ((LinkEntry)entry).link;
                ScreenUtil.openLink(this.parent, link, this.parent.getSelectedEntry().mod.getId() + "/link");
            }
        }
        this.minecraft.method_2112((class_32)this.parent);
    }

    private String creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[\\s-]", "_").toLowerCase();
        return class_300.method_992().method_993("modmenu.credits.role." + translationKey) + ":";
    }

    protected class DescriptionEntry
    implements ModMenuEntryListWidget.Entry {
        protected String text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(String text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(String text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        @Override
        public void render(int index, int x, int y, int width, int height, class_67 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
            DescriptionListWidgetModMenu.this.textRenderer.method_1903(this.text, x + this.indent, y, 0xAAAAAA);
        }

        @Override
        public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            return false;
        }

        @Override
        public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(String text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(String text, String link) {
            this(text, link, 0);
        }

        @Override
        public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            if (DescriptionListWidgetModMenu.this.isMouseInList(mouseX, mouseY)) {
                DescriptionListWidgetModMenu.this.minecraft.method_2112((class_32)new ConfirmChatLinkScreen(DescriptionListWidgetModMenu.this.parent, this.link, 10 + index){

                    @Override
                    public void copy() {
                    }
                });
            }
            return super.mouseClicked(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
        }
    }
}

