/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.util.mod;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.danygames2014.modmenu.util.mod.fabric.FabricIconHandler;
import net.minecraft.class_300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mod {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    default public String getTranslatedName() {
        String translationKey = "modmenu.nameTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_NAMES.getValue()) && TranslationUtil.hasTranslation(translationKey)) {
            return class_300.method_992().method_993(translationKey);
        }
        return this.getName();
    }

    @NotNull
    public BufferedImage getIcon(FabricIconHandler var1, int var2);

    @NotNull
    default public String getSummary() {
        return this.getTranslatedSummary();
    }

    @NotNull
    default public String getTranslatedSummary() {
        String translationKey = "modmenu.summaryTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && TranslationUtil.hasTranslation(translationKey)) {
            return class_300.method_992().method_993(translationKey);
        }
        return this.getTranslatedDescription();
    }

    @NotNull
    public String getDescription();

    @NotNull
    default public String getTranslatedDescription() {
        String translatableDescriptionKey = "modmenu.descriptionTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && TranslationUtil.hasTranslation(translatableDescriptionKey)) {
            return class_300.method_992().method_993(translatableDescriptionKey);
        }
        return this.getDescription();
    }

    @NotNull
    public String getVersion();

    @NotNull
    public String getPrefixedVersion();

    @NotNull
    public List<String> getAuthors();

    @NotNull
    public Map<String, Collection<String>> getContributors();

    @NotNull
    public SortedMap<String, Set<String>> getCredits();

    @NotNull
    public Set<Badge> getBadges();

    @Nullable
    public String getWebsite();

    @Nullable
    public String getIssueTracker();

    @Nullable
    public String getSource();

    @Nullable
    public String getParent();

    @NotNull
    public Set<String> getLicense();

    @NotNull
    public Map<String, String> getLinks();

    public boolean isReal();

    public void setChildHasUpdate();

    public boolean getChildHasUpdate();

    public boolean isHidden();

    public static enum Badge {
        LIBRARY("modmenu.badge.library", -15698860, -16172759, "library"),
        CLIENT("modmenu.badge.clientsideOnly", -13939844, -15848875, "client"),
        DEPRECATED("modmenu.badge.deprecated", -8121306, -11334633, "deprecated"),
        PATCHWORK_FORGE("modmenu.badge.forge", -14734014, -15722719, null),
        MODPACK("modmenu.badge.modpack", -8770692, -11465388, null),
        MINECRAFT("modmenu.badge.minecraft", -9474966, -13553617, null);

        private final String translationKey;
        private final int outlineColor;
        private final int fillColor;
        private final String key;
        private static final Map<String, Badge> KEY_MAP;

        private Badge(String translationKey, int outlineColor, int fillColor, String key) {
            this.translationKey = translationKey;
            this.outlineColor = outlineColor;
            this.fillColor = fillColor;
            this.key = key;
        }

        public String getText() {
            return class_300.method_992().method_993(this.translationKey);
        }

        public int getOutlineColor() {
            return this.outlineColor;
        }

        public int getFillColor() {
            return this.fillColor;
        }

        public static Set<Badge> convert(Set<String> badgeKeys, String modId) {
            return badgeKeys.stream().map(key -> {
                if (!KEY_MAP.containsKey(key)) {
                    ModMenu.LOGGER.warn("Skipping unknown badge key '{}' specified by mod '{}'", key, (Object)modId);
                }
                return KEY_MAP.get(key);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        static {
            KEY_MAP = new HashMap<String, Badge>();
            Arrays.stream(Badge.values()).forEach(badge -> KEY_MAP.put(badge.key, (Badge)((Object)badge)));
        }
    }
}

