/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.spawneggs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.danygames2014.spawneggs.ConfigHandler;
import net.danygames2014.spawneggs.LocalizationHandler;
import net.danygames2014.spawneggs.api.event.SpawnEggColorizationEvent;
import net.danygames2014.spawneggs.item.DevSwordItem;
import net.danygames2014.spawneggs.item.SpawnEggItem;
import net.danygames2014.spawneggs.mixin.EntityRegistryAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import net.minecraft.class_124;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.mod.InitEvent;
import net.modificationstation.stationapi.api.event.registry.ItemRegistryEvent;
import net.modificationstation.stationapi.api.event.resource.language.TranslationInvalidationEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EntrypointManager;
import net.modificationstation.stationapi.api.util.Namespace;
import org.apache.logging.log4j.Logger;

public class SpawnEggs {
    @Entrypoint.Namespace
    public static Namespace MOD_ID;
    @Entrypoint.Logger
    public static Logger LOGGER;
    public static class_124 devSword;
    public static ArrayList<SpawnEggItem> spawnEggs;
    public static List<String> entityRegistry;

    @EventListener(priority=ListenerPriority.LOWEST)
    public void registerItems(ItemRegistryEvent event) {
        if (ConfigHandler.config.allowDevSword.booleanValue()) {
            devSword = new DevSwordItem(MOD_ID.id("dev_sword")).setTranslationKey(MOD_ID, "dev_sword");
        }
        entityRegistry = EntityRegistryAccessor.getEntities().values().stream().sorted().toList();
        List<String> entityBlacklist = Arrays.stream(ConfigHandler.config.blacklistedEntities).toList();
        for (String item : entityRegistry) {
            if (!entityBlacklist.contains(item)) {
                LOGGER.info("Adding Spawn Egg for " + item);
                spawnEggs.add(new SpawnEggItem(item, true));
                continue;
            }
            LOGGER.info("Entity " + item + " found on blacklist, not adding!");
        }
        StationAPI.EVENT_BUS.post((Event)new SpawnEggColorizationEvent());
    }

    @EventListener
    public void localizeSpawnEggs(TranslationInvalidationEvent event) {
        for (SpawnEggItem egg : spawnEggs) {
            LocalizationHandler.registerSpawnEggLocalization(egg.spawnedEntity);
        }
    }

    @EventListener(priority=ListenerPriority.HIGHEST)
    public void preInit(InitEvent event) {
        FabricLoader.getInstance().getEntrypointContainers("spawneggs:event_bus", Object.class).forEach(EntrypointManager::setup);
    }

    static {
        spawnEggs = new ArrayList();
    }
}

