/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.spawneggs.events.init;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.danygames2014.spawneggs.ColorizationHandler;
import net.danygames2014.spawneggs.ConfigHandler;
import net.danygames2014.spawneggs.SpawnEggs;
import net.danygames2014.spawneggs.item.SpawnEggItem;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_206;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.client.event.color.item.ItemColorsRegisterEvent;
import net.modificationstation.stationapi.api.client.event.render.model.PreLoadUnbakedModelEvent;
import net.modificationstation.stationapi.api.client.event.texture.TextureRegisterEvent;
import net.modificationstation.stationapi.api.client.render.model.json.JsonUnbakedModel;
import net.modificationstation.stationapi.api.client.texture.TextureHelper;
import net.modificationstation.stationapi.api.item.ItemConvertible;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Null;

public class TextureListener {
    public static JsonUnbakedModel eggModel = JsonUnbakedModel.deserialize((String)"{\"parent\":\"item/generated\",\"textures\":{\"layer0\":\"spawneggs:item/spawn_egg_outer\",\"layer1\":\"spawneggs:item/spawn_egg_inner\",\"layer2\":\"spawneggs:item/spawn_egg_inner_overlay\"}}");
    @Entrypoint.Namespace
    public static Namespace MOD_ID = (Namespace)Null.get();

    @EventListener
    public void registerTextures(TextureRegisterEvent event) {
        if (ConfigHandler.config.allowDevSword.booleanValue()) {
            SpawnEggs.devSword.setTexture(MOD_ID.id("item/dev_sword"));
        }
    }

    public void colorFromTextureExperiment() {
        for (SpawnEggItem item : SpawnEggs.spawnEggs) {
            class_57 entity = class_206.method_732((String)item.spawnedEntity, null);
            String textureId = entity.method_1314();
            if (textureId == null) continue;
            BufferedImage texture = TextureHelper.getTexture((String)textureId);
            int[] pixels = new int[texture.getWidth() * texture.getHeight()];
            texture.getRGB(0, 0, texture.getWidth(), texture.getHeight(), pixels, 0, texture.getWidth());
            int lightestColorL = 0;
            Color lightestColor = null;
            int darkestColorL = 255;
            Color darkestColor = null;
            for (int colorInt : pixels) {
                int A = colorInt >> 24 & 0xFF;
                int R = colorInt >> 16 & 0xFF;
                int G = colorInt >> 8 & 0xFF;
                int B = colorInt & 0xFF;
                if (A < 128) continue;
                int L = R + R + R + B + G + G + G + G >> 3;
                Color color = new Color(R, G, B);
                if (L > lightestColorL) {
                    lightestColorL = L;
                    lightestColor = color;
                }
                if (L >= darkestColorL) continue;
                darkestColorL = L;
                darkestColor = color;
            }
        }
    }

    @EventListener
    public void registerModel(PreLoadUnbakedModelEvent event) {
        if (event.identifier.namespace.equals((Object)SpawnEggs.MOD_ID) && event.identifier.path.contains("spawn_egg")) {
            event.loader = identifier -> eggModel;
        }
    }

    @EventListener
    public void registerSpawnEggColors(ItemColorsRegisterEvent event) {
        for (SpawnEggItem item : SpawnEggs.spawnEggs) {
            event.itemColors.register((itemInstance, layer) -> ColorizationHandler.eggColor.get(item.spawnedEntity)[layer], new ItemConvertible[]{item});
        }
    }
}

