package net.danygames2014.spawneggs.item;

import net.danygames2014.spawneggs.ColorizationHandler;
import net.danygames2014.spawneggs.ConfigHandler;
import net.danygames2014.spawneggs.SpawnEggs;
import net.danygames2014.spawneggs.mixin.EntityRegistryAccessor;
import net.minecraft.class_104;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_620;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.item.CustomTooltipProvider;
import net.modificationstation.stationapi.api.client.texture.TextureHelper;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Formatting;

public class SpawnEggItem extends TemplateItem implements CustomTooltipProvider {

    // Registry name of the spawned entity
    public String spawnedEntity;

    /**
     * Creates a new Spawn Egg Item using the supplied colors
     * @param spawnedEntity Registry Name of the spawned entity
     * @param outerLayerColorHex Outer Layer color in Hex
     * @param innerLayerColorHex Inner Layer color in Hex
     * @param innerLayerOverlayColorHex Inner Overlay Layer color in Hex
     */
    public SpawnEggItem(String spawnedEntity, int outerLayerColorHex, int innerLayerColorHex, int innerLayerOverlayColorHex) {
        this(spawnedEntity);

        ColorizationHandler.registerSpawnEggColorHex(spawnedEntity, outerLayerColorHex, innerLayerColorHex, innerLayerOverlayColorHex);
    }

    /**
     * Creates a new Spawn Egg Item with the default color
     * @param spawnedEntity Registry Name of the spawned entity
     */
    public SpawnEggItem(String spawnedEntity, boolean tryUsePredefinedColors){
        this(spawnedEntity);

        if(tryUsePredefinedColors){
            if(ColorizationHandler.defaultEggColors.containsKey(spawnedEntity)){
                int[] colors = ColorizationHandler.defaultEggColors.get(spawnedEntity);
                ColorizationHandler.registerSpawnEggColorHex(spawnedEntity,colors[0],colors[1],colors[2]);
                return;
            }
        }
        ColorizationHandler.registerSpawnEggColorInt(spawnedEntity,ColorizationHandler.BASE_COLOR,ColorizationHandler.BASE_COLOR,ColorizationHandler.BASE_COLOR);
    }

    public SpawnEggItem(String spawnedEntity) {
        super(SpawnEggs.MOD_ID.id(spawnedEntity.toLowerCase()+"_spawn_egg"));
        this.spawnedEntity = spawnedEntity;

        setTranslationKey(SpawnEggs.MOD_ID, spawnedEntity.toLowerCase() + "_spawn_egg");
    }

    @Override
    public boolean method_444(class_31 item, class_54 player, class_18 world, int x, int y, int z, int side) {
        Class<? extends class_57> entityClass = EntityRegistryAccessor.getStringToIdMap().get(this.spawnedEntity);
        if(!class_127.class.isAssignableFrom(entityClass)){
            SpawnEggs.LOGGER.debug("This entity cannot be set as a spawner entity due to it not being a Living Entity");
            return true;
        }

        BlockState blockState = world.getBlockState(x,y,z);
        if(blockState.getBlock() instanceof class_620){
            class_104 spawner = (class_104) world.method_1777(x,y,z);
            spawner.method_2035(this.spawnedEntity);
            return true;
        }

        return spawnEntity(item, player, world, x, y, z, side);
    }

    @Override
    public class_31 method_451(class_31 item, class_18 world, class_54 player) {
        if(ConfigHandler.config.allowSpawnInAir){
            spawnEntity(item, player, world, player.field_1600, player.field_1601, player.field_1602, 6);
        }
        return item;
    }


    @Override
    public String[] getTooltip(class_31 itemInstance, String originalTooltip) {
        return new String[]{
                originalTooltip,
                "Registry Name : " + spawnedEntity
        };
    }


    // Spawns the entity defined in spawnedEntity
    private boolean spawnEntity(class_31 item, class_54 player, class_18 level, double x, double y, double z, int side){
        if(level.field_180){
            return true;
        }

        try {

            // Create Entity
            class_57 entity = class_206.method_732(spawnedEntity, level);

            // Determine coordinates according to block side
            switch (side){
                case 0: y-=entity.field_1633; break; // BOTTOM (Y--)
                case 1: y++; x+=0.5; z+=0.5; break; // TOP (Y++)
                case 2: z-=0.5; x+=0.5; break; // SIDE (Z--)
                case 3: z+=1.5; x+=0.5; break; // SIDE (Z++)
                case 4: x-=0.5; z+=0.5; break; // SIDE (X--)
                case 5: x+=1.5; z+=0.5; break; // SIDE (X++)
                default: y++; break;
            }

            // Set the Entity position
            entity.method_1340(x,y,z);

            // Spawn the Entity
            level.method_210(entity);

        } catch (Exception e){
            SpawnEggs.LOGGER.error("Error when spawning Entity! \n" + e.getMessage());
            player.method_490(Formatting.RED + "Error when spawning the entity!");
            if(ConfigHandler.config.removeInvalidSpawnEggs){
                item.field_751 = 0;
                player.method_490(Formatting.RED + "Removed invalid Spawn Egg! You can change this in config");
            }
            return false;
        }

        if(ConfigHandler.config.consumeSpawnEgg){
            item.field_751--;
        }

        return true;
    }
}
