/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.spawneggs.item;

import net.danygames2014.spawneggs.ColorizationHandler;
import net.danygames2014.spawneggs.ConfigHandler;
import net.danygames2014.spawneggs.SpawnEggs;
import net.danygames2014.spawneggs.mixin.EntityRegistryAccessor;
import net.minecraft.class_104;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_620;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.item.CustomTooltipProvider;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Formatting;

public class SpawnEggItem
extends TemplateItem
implements CustomTooltipProvider {
    public String spawnedEntity;

    public SpawnEggItem(String spawnedEntity, int outerLayerColorHex, int innerLayerColorHex, int innerLayerOverlayColorHex) {
        this(spawnedEntity);
        ColorizationHandler.registerSpawnEggColorHex(spawnedEntity, outerLayerColorHex, innerLayerColorHex, innerLayerOverlayColorHex);
    }

    public SpawnEggItem(String spawnedEntity, boolean tryUsePredefinedColors) {
        this(spawnedEntity);
        if (tryUsePredefinedColors && ColorizationHandler.defaultEggColors.containsKey(spawnedEntity)) {
            int[] colors = ColorizationHandler.defaultEggColors.get(spawnedEntity);
            ColorizationHandler.registerSpawnEggColorHex(spawnedEntity, colors[0], colors[1], colors[2]);
            return;
        }
        ColorizationHandler.registerSpawnEggColorInt(spawnedEntity, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF);
    }

    public SpawnEggItem(String spawnedEntity) {
        super(SpawnEggs.MOD_ID.id(spawnedEntity.toLowerCase() + "_spawn_egg"));
        this.spawnedEntity = spawnedEntity;
        this.setTranslationKey(SpawnEggs.MOD_ID, spawnedEntity.toLowerCase() + "_spawn_egg");
    }

    public boolean method_444(class_31 item, class_54 player, class_18 world, int x, int y, int z, int side) {
        Class<? extends class_57> entityClass = EntityRegistryAccessor.getStringToIdMap().get(this.spawnedEntity);
        if (!class_127.class.isAssignableFrom(entityClass)) {
            SpawnEggs.LOGGER.debug("This entity cannot be set as a spawner entity due to it not being a Living Entity");
            return true;
        }
        BlockState blockState = world.getBlockState(x, y, z);
        if (blockState.getBlock() instanceof class_620) {
            class_104 spawner = (class_104)world.method_1777(x, y, z);
            spawner.method_2035(this.spawnedEntity);
            return true;
        }
        return this.spawnEntity(item, player, world, x, y, z, side);
    }

    public class_31 method_451(class_31 item, class_18 world, class_54 player) {
        if (ConfigHandler.config.allowSpawnInAir.booleanValue()) {
            this.spawnEntity(item, player, world, player.field_1600, player.field_1601, player.field_1602, 6);
        }
        return item;
    }

    public String[] getTooltip(class_31 itemInstance, String originalTooltip) {
        return new String[]{originalTooltip, "Registry Name : " + this.spawnedEntity};
    }

    private boolean spawnEntity(class_31 item, class_54 player, class_18 level, double x, double y, double z, int side) {
        if (level.field_180) {
            return true;
        }
        try {
            class_57 entity = class_206.method_732((String)this.spawnedEntity, (class_18)level);
            switch (side) {
                case 0: {
                    y -= (double)entity.field_1633;
                    break;
                }
                case 1: {
                    y += 1.0;
                    x += 0.5;
                    z += 0.5;
                    break;
                }
                case 2: {
                    z -= 0.5;
                    x += 0.5;
                    break;
                }
                case 3: {
                    z += 1.5;
                    x += 0.5;
                    break;
                }
                case 4: {
                    x -= 0.5;
                    z += 0.5;
                    break;
                }
                case 5: {
                    x += 1.5;
                    z += 0.5;
                    break;
                }
                default: {
                    y += 1.0;
                }
            }
            entity.method_1340(x, y, z);
            level.method_210(entity);
        }
        catch (Exception e) {
            SpawnEggs.LOGGER.error("Error when spawning Entity! \n" + e.getMessage());
            player.method_490(Formatting.RED + "Error when spawning the entity!");
            if (ConfigHandler.config.removeInvalidSpawnEggs.booleanValue()) {
                item.field_751 = 0;
                player.method_490(Formatting.RED + "Removed invalid Spawn Egg! You can change this in config");
            }
            return false;
        }
        if (ConfigHandler.config.consumeSpawnEgg.booleanValue()) {
            --item.field_751;
        }
        return true;
    }
}

