/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.hmifabric;

import blue.endless.jankson.Comment;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Function;
import net.glasslauncher.hmifabric.tabs.Tab;
import net.glasslauncher.hmifabric.tabs.TabRegistry;
import net.glasslauncher.mods.api.gcapi.api.ConfigName;
import net.glasslauncher.mods.api.gcapi.api.GCAPI;
import net.glasslauncher.mods.api.gcapi.api.GConfig;
import net.glasslauncher.mods.api.gcapi.api.MultiplayerSynced;
import net.glasslauncher.mods.api.gcapi.impl.ConfigFactories;
import net.modificationstation.stationapi.api.util.Identifier;

public class Config {
    @GConfig(value="config", visibleName="HMI Config")
    public static ConfigFields config = new ConfigFields();
    public static boolean isHMIServer = false;

    public static void orderTabs() {
        Tab tab;
        int i;
        ArrayList<Tab> orderedTabs = new ArrayList<Tab>();
        for (i = 0; i < TabRegistry.INSTANCE.tabOrder.size(); ++i) {
            tab = TabRegistry.INSTANCE.tabOrder.get(i);
            while (orderedTabs.size() < tab.index + 1) {
                orderedTabs.add(null);
            }
            if (tab.index < 0) continue;
            orderedTabs.set(tab.index, tab);
        }
        while (orderedTabs.remove(null)) {
        }
        for (i = 0; i < orderedTabs.size(); ++i) {
            ((Tab)orderedTabs.get((int)i)).index = i;
        }
        for (i = 0; i < TabRegistry.INSTANCE.tabOrder.size(); ++i) {
            tab = TabRegistry.INSTANCE.tabOrder.get(i);
            if (tab.index == -2) {
                tab.index = orderedTabs.size();
                orderedTabs.add(tab);
                continue;
            }
            if (tab.index >= 0) continue;
            tab.index = -1;
        }
        TabRegistry.INSTANCE.tabOrder = orderedTabs;
    }

    public static void tabOrderChanged(boolean[] tabEnabled, Tab[] tabOrder) {
        for (int i = 0; i < TabRegistry.INSTANCE.tabOrder.size(); ++i) {
            Tab tab = TabRegistry.INSTANCE.tabOrder.get(i);
            for (int j = 0; j < tabOrder.length; ++j) {
                if (!tab.equals(tabOrder[j])) continue;
                tab.index = j;
                if (tabEnabled[j]) continue;
                tab.index = -1;
            }
        }
    }

    public static void writeConfig() {
        try {
            JsonObject jsonObject = new JsonObject();
            for (Field field : ConfigFields.class.getDeclaredFields()) {
                jsonObject.put(field.getName(), (JsonElement)((Function)ConfigFactories.saveFactories.get(field.getType())).apply(field.get(config)));
            }
            jsonObject.put("forceNotMultiplayer", (JsonElement)new JsonPrimitive((Object)true));
            GCAPI.reloadConfig((Identifier)Identifier.of((String)"hmifabric:config"), (String)jsonObject.toJson());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static class ConfigFields {
        @ConfigName(value="Overlay Enabled")
        public Boolean overlayEnabled = true;
        @ConfigName(value="Cheats Enabled")
        public Boolean cheatsEnabled = false;
        @ConfigName(value="Show Item IDs")
        public Boolean showItemIDs = false;
        @ConfigName(value="Center Search Bar")
        public Boolean centredSearchBar = false;
        @ConfigName(value="Fast Search")
        public Boolean fastSearch = false;
        @ConfigName(value="Inverted Scrolling")
        public Boolean scrollInverted = false;
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Give Command")
        public String mpGiveCommand = "/give {0} {1} {2}";
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Heal Command")
        public String mpHealCommand = "";
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Time Day Command")
        public String mpTimeDayCommand = "/time set 0";
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Time Night Command")
        public String mpTimeNightCommand = "/time set 13000";
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Rain On Command")
        public String mpRainONCommand = "";
        @MultiplayerSynced
        @ConfigName(value="Multiplayer Rain Off Command")
        public String mpRainOFFCommand = "";
        @ConfigName(value="Draggable Recipe Viewer")
        public Boolean recipeViewerDraggableGui = false;
        @ConfigName(value="Show Null Name Items")
        @Comment(value="Shows items with null names. Can cause crashes with poorly made mods.")
        public Boolean hideNullNames = false;
        @ConfigName(value="Developer Mode")
        @Comment(value="Enables some extra tooltips. Breaks relatively easily, but shouldn't cause crashes.")
        public Boolean devMode = false;
        @ConfigName(value="Recipe Viewer GUI Width")
        public Integer recipeViewerGuiWidth = 251;
        @ConfigName(value="Recipe Viewer GUI Height")
        public Integer recipeViewerGuiHeight = 134;
    }
}

