/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.hmifabric;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.hmifabric.Config;
import net.glasslauncher.hmifabric.GuiOverlay;
import net.glasslauncher.hmifabric.HowManyItems;
import net.glasslauncher.hmifabric.HowManyItemsClient;
import net.glasslauncher.hmifabric.event.HMIItemListRefreshEvent;
import net.glasslauncher.hmifabric.mixin.access.ContainerBaseAccessor;
import net.glasslauncher.hmifabric.tabs.Tab;
import net.minecraft.class_124;
import net.minecraft.class_133;
import net.minecraft.class_148;
import net.minecraft.class_160;
import net.minecraft.class_293;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_386;
import net.minecraft.class_583;
import net.minecraft.class_584;
import net.minecraft.class_92;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class Utils {
    private static ArrayList<class_31> allItems;
    public static class_92 itemRenderer;
    public static Random rand;
    public static class_584 gui;
    private static final List<String> loadedResources;
    private static final List<String> missingResources;
    private static final String resourcesFolder = "/hmi/resources/";
    public static ArrayList<class_31> hiddenItems;
    private static boolean itemLighting;
    private static boolean localTextureBound;
    public static Boolean lighting;
    private static String tooltipText;
    private static int tooltipX;
    private static int tooltipY;

    public static Minecraft getMC() {
        return (Minecraft)FabricLoader.getInstance().getGameInstance();
    }

    public static String getNiceItemName(class_31 item, boolean withID) {
        Object s = class_300.method_992().method_995(item.method_726());
        if ((s == null || ((String)s).length() == 0) && (s = item.method_726()) == null) {
            s = "null";
        }
        if (Config.config.showItemIDs.booleanValue() && withID) {
            s = (String)s + " " + item.field_753;
            if (item.method_719()) {
                s = (String)s + ":" + item.method_722();
            }
        }
        return s;
    }

    public static String getNiceItemName(class_31 item) {
        return Utils.getNiceItemName(item, true);
    }

    public static class_31 hoveredItem(class_293 gui, int posX, int posY) {
        try {
            class_133 slotAtPosition = ((ContainerBaseAccessor)gui).invokeGetSlot(posX, posY);
            if (slotAtPosition != null) {
                return slotAtPosition.method_472();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList<class_31> itemList() {
        if (allItems == null) {
            class_124[] mcItemsList;
            allItems = new ArrayList();
            block2: for (class_124 item : mcItemsList = class_124.field_468) {
                if (item == null) continue;
                HashSet<Object> currentItemNames = new HashSet<Object>();
                int dmg = 0;
                while (true) {
                    class_31 itemstack = new class_31(item, 1, dmg);
                    for (class_31 hiddenItem : GuiOverlay.hiddenItems) {
                        if (!itemstack.method_702(hiddenItem)) continue;
                        itemstack = hiddenItem;
                        break;
                    }
                    try {
                        int l = item.method_439(itemstack);
                        Object s = class_300.method_992().method_995(itemstack.method_726());
                        if (((String)s).length() == 0) {
                            s = itemstack.method_726() + "@" + l;
                        }
                        if (dmg >= 4 && (((String)s).contains(String.valueOf(dmg)) || ((String)s).contains(String.valueOf(dmg + 1)) || ((String)s).contains(String.valueOf(dmg - 1))) || currentItemNames.contains(s = (String)s + "@" + l)) continue block2;
                        allItems.add(itemstack);
                        currentItemNames.add(s);
                    }
                    catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
                        continue block2;
                    }
                    ++dmg;
                }
            }
            List recipes = class_148.method_538().method_541();
            for (class_160 recipe : recipes) {
                if (recipe == null || recipe.method_2073() == null || recipe.method_2073().method_694() == null) continue;
                class_31 itemstack = new class_31(recipe.method_2073().method_694(), 1, recipe.method_2073().method_722());
                for (class_31 hiddenItem : GuiOverlay.hiddenItems) {
                    if (!itemstack.method_702(hiddenItem)) continue;
                    itemstack = hiddenItem;
                    break;
                }
                if (!itemstack.method_719()) continue;
                Utils.addItemInOrder(allItems, itemstack);
            }
            FabricLoader.getInstance().getEntrypoints(HowManyItems.MODID.id("item_list_refresh").toString(), HMIItemListRefreshEvent.class).forEach(hmiItemListRefreshEvent -> hmiItemListRefreshEvent.refreshItemList(allItems));
        }
        return allItems;
    }

    public static void addItemInOrder(ArrayList<class_31> itemList, class_31 itemstack) {
        for (class_31 item : itemList) {
            if (item.method_702(itemstack)) {
                return;
            }
            if (item.field_753 <= itemstack.field_753 && (item.field_753 != itemstack.field_753 || item.method_722() <= itemstack.method_722())) continue;
            itemList.add(itemList.indexOf(item), itemstack);
            return;
        }
    }

    public static int visibleTabSize() {
        int largestIndex = -1;
        for (Tab tab : HowManyItemsClient.getTabs()) {
            if (tab.index <= largestIndex) continue;
            largestIndex = tab.index;
        }
        return largestIndex + 1;
    }

    public static void drawScaledItem(class_31 item, int x, int y, int length) {
        GL11.glPushMatrix();
        float scaleFactor = (float)length / 16.0f;
        GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)1.0f);
        Utils.drawItemStack((int)((float)x / scaleFactor), (int)((float)y / scaleFactor), item, true);
        GL11.glPopMatrix();
    }

    public static void drawRect(int i, int j, int k, int l, int colour) {
        Utils.disableLighting();
        HowManyItemsClient.drawRect(i, j, k, l, colour);
    }

    public static void drawSlot(int x, int y, int colour) {
        Utils.drawRect(x, y, x + 18, y + 18, colour);
    }

    public static void drawArrow(int x, int y) {
        Utils.disableLighting();
        Utils.bindTexture();
        gui.method_1936(x, y, 0, 63, 25, 25);
    }

    public static void drawSlot(int x, int y) {
        Utils.disableLighting();
        Utils.bindTexture();
        gui.method_1936(x, y, 25, 63, 25, 25);
    }

    public static void drawTooltip(String s, int x, int y) {
        tooltipText = s;
        tooltipX = x;
        tooltipY = y;
    }

    public static void drawStoredToolTip() {
        if (tooltipText != null) {
            Utils.disableLighting();
            int k1 = tooltipX + 12;
            int i2 = tooltipY - 12;
            int j2 = Utils.getMC().field_2815.method_1901(tooltipText);
            Utils.drawRect(k1 - 3, i2 - 3, k1 + j2 + 3, i2 + 8 + 3, -1073741824);
            Utils.getMC().field_2815.method_1903(tooltipText, k1, i2, -1);
            tooltipText = null;
            Utils.postRender();
        }
    }

    public static void disableLighting() {
        if (lighting != Boolean.FALSE) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            lighting = false;
        }
    }

    private static void enableLighting() {
        if (lighting != Boolean.TRUE) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            lighting = true;
        }
    }

    public static void bindTexture(String texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.getMC().field_2814.method_1097(Utils.getMC().field_2814.method_1100(texturePath));
        localTextureBound = false;
    }

    public static void bindTexture() {
        if (!localTextureBound) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.getMC().field_2814.method_1097(Utils.getMC().field_2814.method_1100(Utils.getResource("/assets/hmifabric/textures/icons.png")));
            localTextureBound = true;
        }
    }

    public static void drawItemStack(int x, int y, class_31 item, boolean drawOverlay) {
        localTextureBound = false;
        Utils.enableItemLighting();
        itemRenderer.method_1487(Utils.getMC().field_2815, Utils.getMC().field_2814, item, x, y);
        if (drawOverlay) {
            itemRenderer.method_1488(Utils.getMC().field_2815, Utils.getMC().field_2814, item, x, y);
        }
    }

    private static void enableItemLighting() {
        Utils.enableLighting();
        if (!itemLighting) {
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            class_583.method_1930();
            GL11.glPopMatrix();
            itemLighting = true;
        }
    }

    public static void drawString(String s, int x, int y) {
        Utils.disableLighting();
        int k1 = x + 12;
        int i2 = y - 12;
        Utils.getMC().field_2815.method_1903(s, k1, i2, -1);
    }

    public static void preRender() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        lighting = null;
        itemLighting = false;
        localTextureBound = false;
    }

    public static void postRender() {
        lighting = null;
        class_583.method_1927();
        Utils.enableLighting();
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static boolean nmsClassExists(String className) {
        return Utils.classExists(className) || Utils.classExists("net.minecraft.src." + className);
    }

    public static String getResource(String resource) {
        Utils.resourceExists(resource);
        return resource;
    }

    public static boolean resourceExists(String resource) {
        if (loadedResources.contains(resource)) {
            return true;
        }
        if (missingResources.contains(resource)) {
            return false;
        }
        if (Utils.class.getResource(resource) != null) {
            loadedResources.add(resource);
            return true;
        }
        missingResources.add(resource);
        String error = "Missing file " + new File("bin\\minecraft.jar").getAbsolutePath().replace("\\", "/") + resource;
        if (System.getProperty("java.class.path").toLowerCase().contains("eclipse")) {
            Utils.logError(error, "Alternate Location " + HowManyItemsClient.class.getClassLoader().getResource("").getPath().replaceFirst("/*$", "") + resource);
        } else {
            Utils.logError(error);
        }
        return false;
    }

    public static void logError(String ... lines) {
        System.out.println("HMI ERROR: " + lines[0]);
        for (String message : lines) {
            if (Objects.equals(message, lines[0])) continue;
            System.out.println("\t" + message);
        }
    }

    public static Object getHandler(String path) {
        try {
            return Utils.class.getClassLoader().loadClass(Utils.class.getPackage().getName() + ".references." + path + ".ConcreteHandler").newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isKeyDown(class_386 keybind) {
        return Utils.isKeyDown(keybind.field_2381);
    }

    public static boolean isKeyDown(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode) && Utils.keyCodeValid(keyCode);
    }

    public static boolean keyEquals(int keyCode, class_386 keybind) {
        return keyCode == keybind.field_2381 && Utils.keybindValid(keybind);
    }

    public static boolean keybindValid(class_386 keybind) {
        return Utils.keyCodeValid(keybind.field_2381);
    }

    public static boolean keyCodeValid(int keyCode) {
        return keyCode != 0;
    }

    public static Object getPrivateValue(Class instanceclass, Object instance, int fieldindex) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f = instanceclass.getDeclaredFields()[fieldindex];
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isGuiOpen(Class gui) {
        if (gui == null) {
            return Utils.getMC().field_2816 == null;
        }
        if (Utils.getMC().field_2816 == null) {
            return false;
        }
        return gui.isInstance(Utils.getMC().field_2816);
    }

    static {
        itemRenderer = new class_92();
        rand = new Random();
        gui = new class_584();
        loadedResources = new ArrayList<String>();
        missingResources = new ArrayList<String>();
        hiddenItems = new ArrayList();
    }

    public static class EasyField<T> {
        private static final EasyField<Integer> modifiersField = new EasyField(Field.class, "modifiers");
        public final Field field;

        public EasyField(Object value, Class<?> target) {
            this(value, target, null);
        }

        public EasyField(Object value, Class<?> target, Object instance) {
            Field correctField = null;
            for (Field field : target.getDeclaredFields()) {
                try {
                    if (field.get(instance) != value) continue;
                    field.setAccessible(true);
                    correctField = field;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.field = correctField;
            if (this.field == null) {
                Utils.logError("Failed to locate field " + value.getClass().getSimpleName() + " in class " + target.getSimpleName());
            }
        }

        public EasyField(Class<?> target, String ... names) {
            for (Field field : target.getDeclaredFields()) {
                for (String name : names) {
                    if (!field.getName().equals(name)) continue;
                    field.setAccessible(true);
                    this.field = field;
                    return;
                }
            }
            this.field = null;
            Utils.logError("Failed to locate field " + names[0] + " in class " + target.getSimpleName());
        }

        public boolean exists() {
            return this.field != null;
        }

        public T get(Object instance) {
            try {
                return (T)this.field.get(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public T get() {
            return this.get(null);
        }

        public void set(Object instance, T value) {
            try {
                this.field.set(instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void set(T value) {
            this.set(null, value);
        }

        public void removeFinalModifier() {
            modifiersField.set(this.field, this.field.getModifiers() & 0xFFFFFFEF);
        }
    }
}

