/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.hmifabric.tabs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.glasslauncher.hmifabric.Utils;
import net.glasslauncher.hmifabric.tabs.Tab;
import net.minecraft.class_17;
import net.minecraft.class_293;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.Namespace;

public class TabGenericBlock
extends Tab {
    protected Map recipesComplete;
    protected ArrayList<class_31[]> recipes = new ArrayList();
    protected class_17 tabBlock;
    protected int metadata;
    protected int inputSlots;
    protected int outputSlots;
    protected int slotOffsetX = -1;
    protected int slotOffsetY = -4;
    private String name;

    public TabGenericBlock(Namespace tabCreator, Map recipes, class_17 tabBlock) {
        this(tabCreator, recipes, 1, 1, tabBlock, 0);
    }

    public TabGenericBlock(Namespace tabCreator, Map recipes, class_17 tabBlock, String name) {
        this(tabCreator, recipes, 1, 1, tabBlock, 0);
        this.name = name;
    }

    public TabGenericBlock(Namespace tabCreator, Map recipes, class_17 tabBlock, int metadata) {
        this(tabCreator, recipes, 1, 1, tabBlock, metadata);
    }

    public TabGenericBlock(Namespace tabCreator, Map recipes, int inputSlots, int outputSlots, class_17 tabBlock, String name) {
        this(tabCreator, recipes, inputSlots, outputSlots, tabBlock, 0);
        this.name = name;
    }

    public TabGenericBlock(Namespace tabCreator, Map recipes, int inputSlots, int outputSlots, class_17 tabBlock, int metadata) {
        this(tabCreator, inputSlots, outputSlots, recipes, 140, Math.max(42, Math.max(inputSlots * 18 + 4, outputSlots * 18 + 4)), 3, 3, tabBlock, metadata);
    }

    public TabGenericBlock(Namespace tabCreator, int inputSlots, int outputSlots, Map recipes, int width, int height, int minPaddingX, int minPaddingY, class_17 tabBlock, int metadata) {
        super(tabCreator, inputSlots + outputSlots, width, height, minPaddingX, minPaddingY);
        int i;
        this.tabBlock = tabBlock;
        this.metadata = metadata;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.recipesComplete = recipes;
        int inputSlotsHeightOffset = 9 * inputSlots;
        int outputSlotsHeightOffset = 9 * outputSlots;
        for (i = 0; i < inputSlots; ++i) {
            this.slots[i] = new Integer[]{2, this.HEIGHT / 2 - inputSlotsHeightOffset + i * 18 - this.slotOffsetY};
        }
        for (i = 0; i < outputSlots; ++i) {
            this.slots[i + inputSlots] = new Integer[]{this.WIDTH - this.slotOffsetX - 19, this.HEIGHT / 2 - outputSlotsHeightOffset + i * 18 - this.slotOffsetY};
        }
        this.equivalentCraftingStations.add(this.getTabItem());
    }

    @Override
    public class_31[][] getItems(int index, class_31 filter) {
        class_31[][] items = new class_31[this.recipesPerPage][];
        for (int j = 0; j < this.recipesPerPage; ++j) {
            items[j] = new class_31[this.slots.length];
            int k = index + j;
            if (k < this.recipes.size()) {
                class_31[] recipe = this.recipes.get(k);
                for (int i = 0; i < recipe.length; ++i) {
                    items[j][i] = recipe[i];
                    if (recipe[i] == null || recipe[i].method_722() != -1) continue;
                    if (recipe[i].method_719()) {
                        if (filter != null && recipe[i].field_753 == filter.field_753) {
                            items[j][i] = new class_31(recipe[i].method_694(), 0, filter.method_722());
                            continue;
                        }
                        items[j][i] = new class_31(recipe[i].method_694());
                        continue;
                    }
                    if (filter == null || recipe[i].field_753 != filter.field_753) continue;
                    items[j][i] = new class_31(recipe[i].method_694(), 0, filter.method_722());
                }
            }
            if (items[j][0] == null && this.recipesOnThisPage > j) {
                this.recipesOnThisPage = j;
                this.redrawSlots = true;
                break;
            }
            if (items[j][0] == null || this.recipesOnThisPage != j) continue;
            this.recipesOnThisPage = j + 1;
            this.redrawSlots = true;
        }
        return items;
    }

    @Override
    public void updateRecipes(class_31 filter, Boolean getUses) {
        this.lastIndex = 0;
        this.recipes.clear();
        for (Object obj : this.recipesComplete.keySet()) {
            boolean addRecipe = false;
            class_31[] inputs = obj instanceof class_31[] ? (class_31[])obj : new class_31[]{(class_31)obj};
            class_31[] outputs = this.recipesComplete.get(obj) instanceof class_31[] ? (class_31[])this.recipesComplete.get(obj) : new class_31[]{(class_31)this.recipesComplete.get(obj)};
            if (filter == null) {
                addRecipe = true;
            } else if (getUses.booleanValue()) {
                for (int i = 0; i < inputs.length; ++i) {
                    if (inputs[i].field_753 != filter.field_753 || inputs[i].method_722() != filter.method_722() && inputs[i].method_722() >= 0 && inputs[i].method_719()) continue;
                    addRecipe = true;
                    break;
                }
            } else {
                for (int i = 0; i < outputs.length; ++i) {
                    if (outputs[i].field_753 != filter.field_753 || outputs[i].method_722() != filter.method_722() && outputs[i].method_722() >= 0 && outputs[i].method_719()) continue;
                    addRecipe = true;
                    break;
                }
            }
            if (!addRecipe) continue;
            class_31[] recipe = Arrays.copyOf(inputs, this.inputSlots + this.outputSlots);
            System.arraycopy(outputs, 0, recipe, this.inputSlots, outputs.length);
            this.recipes.add(recipe);
        }
        this.size = this.recipes.size();
        super.updateRecipes(filter, getUses);
        this.size = this.recipes.size();
    }

    @Override
    public class_31 getTabItem() {
        return new class_31(this.tabBlock, 1, this.metadata);
    }

    public class_31 getBlockToDraw() {
        return this.getTabItem();
    }

    @Override
    public void draw(int x, int y, int recipeOnThisPageIndex, int cursorX, int cursorY) {
        this.drawSlotsAndArrows(x, y);
        Utils.drawScaledItem(this.getBlockToDraw(), x + this.WIDTH / 2 - 20, y + this.HEIGHT / 2 - 19, 40);
    }

    protected void drawSlotsAndArrows(int x, int y) {
        Utils.bindTexture();
        for (Integer[] slotCoords : this.slots) {
            Utils.drawSlot(x + slotCoords[0] + this.slotOffsetX, y + slotCoords[1] + this.slotOffsetY);
        }
        Utils.drawArrow(x + 23, y + this.HEIGHT / 2 - 12);
        Utils.drawArrow(x + 92, y + this.HEIGHT / 2 - 12);
    }

    @Override
    public String name() {
        if (this.name != null) {
            return this.name;
        }
        return super.name();
    }

    @Override
    public Class<? extends class_293> getGuiClass() {
        return null;
    }
}

