/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.simple;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public final class RecafSimpleFileReader {
    private RecafSimpleFileReader() {
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        RecafSimpleFileReader.read(reader, "source", "target", visitor);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        RecafSimpleFileReader.read(new ColumnFileReader(reader, ' '), sourceNs, targetNs, visitor);
    }

    private static void read(ColumnFileReader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        Set<MappingFlag> flags = visitor.getFlags();
        MappingVisitor parentVisitor = null;
        if (flags.contains((Object)MappingFlag.NEEDS_ELEMENT_UNIQUENESS)) {
            parentVisitor = visitor;
            visitor = new MemoryMappingTree();
        } else if (flags.contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            reader.mark();
        }
        while (true) {
            if (visitor.visitHeader()) {
                visitor.visitNamespaces(sourceNs, Collections.singletonList(targetNs));
            }
            if (visitor.visitContent()) {
                String lastClass = null;
                boolean visitClass = false;
                do {
                    String clsSrcName;
                    String line;
                    if ((line = reader.nextCols(true)) == null || line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                    String[] parts = line.split(" ");
                    int dotPos = parts[0].lastIndexOf(46);
                    String clsDstName = null;
                    String memberSrcName = null;
                    String memberSrcDesc = null;
                    String memberDstName = null;
                    boolean isMethod = false;
                    if (dotPos < 0) {
                        clsSrcName = parts[0];
                        clsDstName = parts[1];
                    } else {
                        clsSrcName = parts[0].substring(0, dotPos);
                        String memberIdentifier = parts[0].substring(dotPos + 1);
                        memberDstName = parts[1];
                        if (parts.length >= 3) {
                            memberSrcName = memberIdentifier;
                            memberSrcDesc = parts[1];
                            memberDstName = parts[2];
                        } else if (parts.length == 2) {
                            int mthDescPos = memberIdentifier.lastIndexOf("(");
                            if (mthDescPos < 0) {
                                memberSrcName = memberIdentifier;
                            } else {
                                isMethod = true;
                                memberSrcName = memberIdentifier.substring(0, mthDescPos);
                                memberSrcDesc = memberIdentifier.substring(mthDescPos);
                            }
                        } else {
                            throw new IOException("Invalid Recaf Simple line " + reader.getLineNumber() + ": Insufficient column count!");
                        }
                    }
                    if (!clsSrcName.equals(lastClass)) {
                        visitClass = visitor.visitClass(clsSrcName);
                        lastClass = clsSrcName;
                        if (visitClass) {
                            if (clsDstName != null) {
                                visitor.visitDstName(MappedElementKind.CLASS, 0, clsDstName);
                            }
                            visitClass = visitor.visitElementContent(MappedElementKind.CLASS);
                        }
                    }
                    if (!visitClass || memberSrcName == null) continue;
                    if (!isMethod && visitor.visitField(memberSrcName, memberSrcDesc)) {
                        visitor.visitDstName(MappedElementKind.FIELD, 0, memberDstName);
                        continue;
                    }
                    if (!isMethod || !visitor.visitMethod(memberSrcName, memberSrcDesc)) continue;
                    visitor.visitDstName(MappedElementKind.METHOD, 0, memberDstName);
                } while (reader.nextLine(0));
            }
            if (visitor.visitEnd()) break;
            reader.reset();
        }
        if (parentVisitor != null) {
            ((MappingTree)((Object)visitor)).accept(parentVisitor);
        }
    }
}

