/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.intermediaryruiner;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaDirReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public class Main {
    private static final int CLIENT = 0;
    private static final int SERVER = 1;
    private static final int CURSED_CLIENT = 2;
    private static final int CURSED_SERVER = 1;
    private static MemoryMappingTree mappings;
    private static MemoryMappingTree cursedInt;
    private static MemoryMappingTree intermediaries;
    private static Field srcName;

    public static void main(String[] args) throws IOException {
        File mappingsDir = new File("mappings");
        File intermediariesFile = new File("mappings.tiny");
        File cursedIntFile = new File(".gradle/minecraft/b1.7.3-intermediary-v2.tiny");
        File output = new File("output");
        File outputTiny = new File(output + ".tiny");
        File bridgeOutput = new File(output + "_bridged");
        bridgeOutput.delete();
        output.delete();
        outputTiny.delete();
        System.out.println("Loading mappings folder");
        if (!mappingsDir.exists()) {
            System.err.println("Mappings folder not found! Make sure you are running this inside your yarn folder.");
            System.out.println(2);
            return;
        }
        mappings = new MemoryMappingTree();
        MappingReader.read(mappingsDir.toPath(), MappingFormat.ENIGMA_DIR, (MappingVisitor)mappings);
        System.out.println("Loading source intermediaries file");
        if (!cursedIntFile.exists()) {
            System.err.println("Source intermediaries not found. Make sure you have ran yarn at least once");
            System.out.println(2);
            return;
        }
        cursedInt = new MemoryMappingTree();
        MappingReader.read(cursedIntFile.toPath(), MappingFormat.TINY_2_FILE, (MappingVisitor)cursedInt);
        System.out.println("Loading target intermediaries file");
        if (!intermediariesFile.exists()) {
            System.err.println("Target intermediaries not found. Make sure they are named \"mappings.tiny\"");
            System.out.println(2);
            return;
        }
        intermediaries = new MemoryMappingTree();
        MappingReader.read(intermediariesFile.toPath(), MappingFormat.TINY_2_FILE, (MappingVisitor)intermediaries);
        System.out.println("Mappings loaded, now causing a massacre.");
        mappings.getClasses().forEach(cursedClass -> {
            MappingTree.ClassMapping cursedIntClass = cursedInt.getClass(cursedClass.getSrcName());
            MappingTreeView.ElementMappingView intClientClass = null;
            MappingTreeView.ElementMappingView intServerClass = null;
            if (cursedIntClass != null) {
                intClientClass = intermediaries.getClass(cursedIntClass.getDstName(2), 0);
                intServerClass = intermediaries.getClass(cursedIntClass.getDstName(1), 1);
            }
            if (intClientClass != null) {
                Main.setSrcName(intClientClass.getSrcName(), cursedClass);
            }
            if (intServerClass != null) {
                Main.setSrcName(intServerClass.getSrcName(), cursedClass);
            }
            Main.handleMethods(cursedClass.getMethods(), (MappingTree.ClassMapping)intClientClass, (MappingTree.ClassMapping)intServerClass, cursedIntClass);
            Main.handleFields(cursedClass.getFields(), (MappingTree.ClassMapping)intClientClass, (MappingTree.ClassMapping)intServerClass, cursedIntClass);
        });
        System.out.println("Converted, saving to \"output\"");
        mappings.accept(MappingWriter.create(output.toPath(), MappingFormat.ENIGMA_DIR));
        System.out.println("Ultra ruining, now making an ornithe compatible tiny file (hopefully.)");
        mappings = new MemoryMappingTree();
        EnigmaDirReader.read(mappingsDir.toPath(), "intermediary", "named", mappings);
        mappings.accept(MappingWriter.create(outputTiny.toPath(), MappingFormat.TINY_2_FILE));
        String file = Files.readString(outputTiny.toPath(), StandardCharsets.UTF_8);
        outputTiny.delete();
        Files.writeString(outputTiny.toPath(), (CharSequence)file.replaceAll("([a-z_0-9<>]+)\\t\n", "$1\t$1\n"), new OpenOption[0]);
        System.out.println("Done! If you have issues, good luck, you'll need it where we're going.");
    }

    public static String generateSemiUniqueID(MappingTree.MemberMapping member, int side) {
        return member.getOwner().getName(side) + "\t" + member.getName(side) + "\t" + member.getDesc(side);
    }

    public static void handleMethods(Collection<? extends MappingTree.MethodMapping> methods, MappingTree.ClassMapping intClientClass, MappingTree.ClassMapping intServerClass, MappingTree.ClassMapping cursedIntClass) {
        Map<String, MappingTree.MethodMapping> clientMethodIndex = intClientClass == null ? null : intClientClass.getMethods().stream().filter(methodMapping -> methodMapping.getName(0) != null).map(methodMapping -> new MethodRecord(Main.generateSemiUniqueID(methodMapping, 0), (MappingTree.MethodMapping)methodMapping)).collect(Collectors.toMap(record -> record.id, record -> record.method));
        Map<String, MappingTree.MethodMapping> serverMethodIndex = intServerClass == null ? null : intServerClass.getMethods().stream().filter(methodMapping -> methodMapping.getName(1) != null).map(methodMapping -> new MethodRecord(Main.generateSemiUniqueID(methodMapping, 1), (MappingTree.MethodMapping)methodMapping)).collect(Collectors.toMap(record -> record.id, record -> record.method));
        methods.forEach(cursedMethod -> {
            MappingTree.MethodMapping intServerMethod;
            MappingTree.MethodMapping cursedIntClientMethod = cursedIntClass.getMethod(cursedMethod.getSrcName(), cursedMethod.getSrcDesc());
            MappingTree.MethodMapping cursedIntServerMethod = cursedIntClass.getMethod(cursedMethod.getSrcName(), cursedMethod.getSrcDesc());
            MappingTree.MethodMapping intClientMethod = clientMethodIndex == null || cursedIntClientMethod == null ? null : (MappingTree.MethodMapping)clientMethodIndex.get(Main.generateSemiUniqueID(cursedIntClientMethod, 0));
            MappingTree.MethodMapping methodMapping = intServerMethod = serverMethodIndex == null || cursedIntServerMethod == null ? null : (MappingTree.MethodMapping)serverMethodIndex.get(Main.generateSemiUniqueID(cursedIntServerMethod, 1));
            if (intClientMethod != null) {
                Main.setSrcName(intClientMethod.getSrcName(), cursedMethod);
            }
            if (intServerMethod != null) {
                Main.setSrcName(intServerMethod.getSrcName(), cursedMethod);
            }
        });
    }

    public static void handleFields(Collection<? extends MappingTree.FieldMapping> fields, MappingTree.ClassMapping intClientClass, MappingTree.ClassMapping intServerClass, MappingTree.ClassMapping cursedIntClass) {
        Map<String, MappingTree.FieldMapping> clientFieldIndex = intClientClass == null ? null : intClientClass.getFields().stream().filter(fieldMapping -> fieldMapping.getName(0) != null).map(fieldMapping -> new FieldRecord(Main.generateSemiUniqueID(fieldMapping, 0), (MappingTree.FieldMapping)fieldMapping)).collect(Collectors.toMap(record -> record.id, record -> record.field));
        Map<String, MappingTree.FieldMapping> serverFieldIndex = intServerClass == null ? null : intServerClass.getFields().stream().filter(fieldMapping -> fieldMapping.getName(1) != null).map(fieldMapping -> new FieldRecord(Main.generateSemiUniqueID(fieldMapping, 1), (MappingTree.FieldMapping)fieldMapping)).collect(Collectors.toMap(record -> record.id, record -> record.field));
        fields.forEach(cursedField -> {
            MappingTree.FieldMapping intServerField;
            MappingTree.FieldMapping cursedIntClientField = cursedIntClass.getField(cursedField.getSrcName(), cursedField.getSrcDesc());
            MappingTree.FieldMapping cursedIntServerField = cursedIntClass.getField(cursedField.getSrcName(), cursedField.getSrcDesc());
            MappingTree.FieldMapping intClientField = clientFieldIndex == null || cursedIntClientField == null ? null : (MappingTree.FieldMapping)clientFieldIndex.get(Main.generateSemiUniqueID(cursedIntClientField, 0));
            MappingTree.FieldMapping fieldMapping = intServerField = serverFieldIndex == null || cursedIntServerField == null ? null : (MappingTree.FieldMapping)serverFieldIndex.get(Main.generateSemiUniqueID(cursedIntServerField, 1));
            if (intClientField != null) {
                Main.setSrcName(intClientField.getSrcName(), cursedField);
            }
            if (intServerField != null) {
                Main.setSrcName(intServerField.getSrcName(), cursedField);
            }
        });
    }

    public static void setSrcName(String name, MappingTree.ElementMapping elementMapping) {
        if (srcName == null) {
            try {
                srcName = elementMapping.getClass().getSuperclass().getDeclaredField("srcName");
                srcName.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        try {
            srcName.set(elementMapping, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    record FieldRecord(String id, MappingTree.FieldMapping field) {
    }

    record MethodRecord(String id, MappingTree.MethodMapping method) {
    }
}

